<?php

namespace EightyNine\ExcelImport;

use EightyNine\ExcelImport\Commands\ExcelImportActionCommand;
use EightyNine\ExcelImport\Testing\TestsExcelImportAction;
use Filament\Support\Assets\AlpineComponent;
use Filament\Support\Assets\Asset;
use Filament\Support\Assets\Css;
use Filament\Support\Assets\Js;
use Filament\Support\Facades\FilamentAsset;
use Filament\Support\Facades\FilamentIcon;
use Illuminate\Filesystem\Filesystem;
use Livewire\Features\SupportTesting\Testable;
use Spatie\LaravelPackageTools\Commands\InstallCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class ExcelImportServiceProvider extends PackageServiceProvider
{
    public static string $name = 'excel-import';

    public static string $viewNamespace = 'excel-import';

    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package->name(static::$name)
            ->hasCommands($this->getCommands())
            ->hasInstallCommand(function (InstallCommand $command) {
                $command
                    ->publishConfigFile()
                    ->publishMigrations()
                    ->askToRunMigrations()
                    ->askToStarRepoOnGitHub('eightynine/filament-excel-import');
            });

        $configFileName = $package->shortName();

        if (file_exists($package->basePath("/../config/{$configFileName}.php"))) {
            $package->hasConfigFile();
        }

        if (file_exists($package->basePath('/../database/migrations'))) {
            $package->hasMigrations($this->getMigrations());
        }

        if (file_exists($package->basePath('/../resources/lang'))) {
            $package->hasTranslations();
        }

        if (file_exists($package->basePath('/../resources/views'))) {
            $package->hasViews(static::$viewNamespace);
        }
    }

    public function packageRegistered(): void {}

    public function packageBooted(): void
    {
        // Asset Registration
        FilamentAsset::register(
            $this->getAssets(),
            $this->getAssetPackageName()
        );

        FilamentAsset::registerScriptData(
            $this->getScriptData(),
            $this->getAssetPackageName()
        );

        // Icon Registration
        FilamentIcon::register($this->getIcons());

        // Handle Stubs
        if (app()->runningInConsole()) {
            foreach (app(Filesystem::class)->files(__DIR__ . '/../stubs/') as $file) {
                $this->publishes([
                    $file->getRealPath() => base_path("stubs/filament-excel-import/{$file->getFilename()}"),
                ], 'filament-excel-import-stubs');
            }
        }

        // Testing
        Testable::mixin(new TestsExcelImportAction);
    }

    protected function getAssetPackageName(): ?string
    {
        return 'eightynine/filament-excel-import';
    }

    /**
     * @return array<Asset>
     */
    protected function getAssets(): array
    {
        $assets = [
            // AlpineComponent::make('filament-excel-import', __DIR__ . '/../resources/dist/components/filament-excel-import.js'),
            Js::make('filament-excel-import-scripts', __DIR__ . '/../resources/dist/filament-excel-import.js'),
        ];

        // Only load stylesheet if explicitly enabled in config
        if (config('excel-import.load_stylesheet', false)) {
            $assets[] = Css::make('filament-excel-import-styles', __DIR__ . '/../resources/dist/filament-excel-import.css');
        }

        return $assets;
    }

    /**
     * @return array<class-string>
     */
    protected function getCommands(): array
    {
        return [
            ExcelImportActionCommand::class,
        ];
    }

    /**
     * @return array<string>
     */
    protected function getIcons(): array
    {
        return [];
    }

    /**
     * @return array<string>
     */
    protected function getRoutes(): array
    {
        return [];
    }

    /**
     * @return array<string, mixed>
     */
    protected function getScriptData(): array
    {
        return [];
    }

    /**
     * @return array<string>
     */
    protected function getMigrations(): array
    {
        return [
            'create_filament-excel-import_table',
        ];
    }
}
