<?php

namespace Tests\Unit;

use App\Filament\Resources\WellLicenseResource\RelationManagers\RequirementsRelationManager;
use App\Models\LicenseRequirement;
use App\Services\PdfMergerService;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase as BaseTestCase;

class WellLicenseRequirementsPdfExportTest extends BaseTestCase
{
    use RefreshDatabase;

    /** @test */
    public function it_has_export_requirements_pdfs_method()
    {
        $reflection = new \ReflectionClass(RequirementsRelationManager::class);
        $this->assertTrue($reflection->hasMethod('exportRequirementsPdfs'));
    }

    /** @test */
    public function license_requirement_has_collect_pdf_files_method()
    {
        $reflection = new \ReflectionClass(LicenseRequirement::class);
        $this->assertTrue($reflection->hasMethod('collectPdfFiles'));

        // Test with empty collection
        $collection = collect([]);
        $result = LicenseRequirement::collectPdfFiles($collection);

        $this->assertIsArray($result);
        $this->assertEmpty($result);
    }

    /** @test */
    public function pdf_merger_service_has_merge_pdfs_method()
    {
        $reflection = new \ReflectionClass(PdfMergerService::class);
        $this->assertTrue($reflection->hasMethod('mergePdfs'));
    }
}
