<?php

namespace Tests\Unit;

use App\Enums\LicenseStatus;
use App\Filament\Resources\StationLicenseResource\Components\StationLicenseApprovalFlow;
use PHPUnit\Framework\TestCase;

class StationLicenseApprovalFlowTest extends TestCase
{
    public function test_get_step_permission_for_initial_approval_status(): void
    {
        $permission = StationLicenseApprovalFlow::getStepPermission(LicenseStatus::INITIAL_APPROVAL);

        $this->assertEquals('approve_initial_station::license', $permission);
    }

    public function test_get_step_permission_for_final_approval_status(): void
    {
        $permission = StationLicenseApprovalFlow::getStepPermission(LicenseStatus::FINAL_APPROVAL);

        $this->assertEquals('approve_final_station::license', $permission);
    }

    public function test_get_step_permission_returns_null_for_created_status(): void
    {
        $permission = StationLicenseApprovalFlow::getStepPermission(LicenseStatus::CREATED);

        $this->assertNull($permission);
    }

    public function test_get_step_permission_returns_null_for_approved_status(): void
    {
        $permission = StationLicenseApprovalFlow::getStepPermission(LicenseStatus::APPROVED);

        $this->assertNull($permission);
    }

    public function test_get_step_permission_returns_null_for_rejected_status(): void
    {
        $permission = StationLicenseApprovalFlow::getStepPermission(LicenseStatus::REJECTED);

        $this->assertNull($permission);
    }
}
