<?php

namespace Tests\Unit;

use App\Models\Order;
use PHPUnit\Framework\TestCase;

class OrderTypeTest extends TestCase
{
    /**
     * Test that the new well purification licenses order type constant exists
     */
    public function test_well_purification_licenses_type_constant_exists()
    {
        $this->assertTrue(defined('App\Models\Order::TYPE_WELL_PURIFICATION_LICENSES'));
        $this->assertEquals('WELL_PURIFICATION_LICENSES', Order::TYPE_WELL_PURIFICATION_LICENSES);
    }

    /**
     * Test that the new order type appears in getAllOrderTypes
     */
    public function test_well_purification_licenses_in_all_order_types()
    {
        $orderTypes = Order::getAllOrderTypes();
        $this->assertArrayHasKey(Order::TYPE_WELL_PURIFICATION_LICENSES, $orderTypes);
    }

    /**
     * Test that the new order type appears in getOrderTypes
     */
    public function test_well_purification_licenses_in_order_types()
    {
        $orderTypes = Order::getOrderTypes();
        $this->assertArrayHasKey(Order::TYPE_WELL_PURIFICATION_LICENSES, $orderTypes);
    }

    /**
     * Test that the new order type has permission mapping
     */
    public function test_well_purification_licenses_has_permission_mapping()
    {
        $permissions = Order::getOrderTypePermissions();
        $this->assertArrayHasKey(Order::TYPE_WELL_PURIFICATION_LICENSES, $permissions);
        $this->assertEquals('view_well_purification_licenses_order_type_order', $permissions[Order::TYPE_WELL_PURIFICATION_LICENSES]);
    }

    /**
     * Test that the new order type has file requirements
     */
    public function test_well_purification_licenses_has_file_requirements()
    {
        $fileRequirements = Order::getTypeFileRequirements();
        $this->assertArrayHasKey(Order::TYPE_WELL_PURIFICATION_LICENSES, $fileRequirements);
        $this->assertArrayHasKey('well_purification_license_form', $fileRequirements[Order::TYPE_WELL_PURIFICATION_LICENSES]);
        $this->assertTrue($fileRequirements[Order::TYPE_WELL_PURIFICATION_LICENSES]['well_purification_license_form']['required']);
    }
}
