<?php

namespace Tests\Unit;

use App\Filament\Resources\ExchangeRequestResource\Pages\ViewExchangeRequest;
use App\Models\ExchangeRequest;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase as BaseTestCase;

class ExchangeRequestPdfExportTest extends BaseTestCase
{
    use RefreshDatabase;

    /** @test */
    public function it_can_collect_pdf_files_from_exchange_request()
    {
        // This is a basic structure test to ensure the method exists and returns an array
        $reflection = new \ReflectionClass(ViewExchangeRequest::class);
        $this->assertTrue($reflection->hasMethod('collectPdfFiles'));

        $method = $reflection->getMethod('collectPdfFiles');
        $method->setAccessible(true);

        // Mock an exchange request
        $exchangeRequest = new ExchangeRequest;

        $viewExchangeRequest = new ViewExchangeRequest;
        $result = $method->invoke($viewExchangeRequest, $exchangeRequest);

        $this->assertIsArray($result);
    }

    /** @test */
    public function it_has_merge_pdfs_method()
    {
        $reflection = new \ReflectionClass(ViewExchangeRequest::class);
        $this->assertTrue($reflection->hasMethod('mergePdfs'));
    }

    /** @test */
    public function it_has_export_pdfs_method()
    {
        $reflection = new \ReflectionClass(ViewExchangeRequest::class);
        $this->assertTrue($reflection->hasMethod('exportPdfs'));
    }
}
