<?php

namespace Tests\Unit;

use App\Models\ExchangeRequest;
use Tests\TestCase;

class ExchangeRequestMultipleFilesTest extends TestCase
{
    /** @test */
    public function it_can_register_transaction_file_collection(): void
    {
        $exchangeRequest = new ExchangeRequest;
        $exchangeRequest->status = ExchangeRequest::STATUS_CREATED;

        $collection = $exchangeRequest->getMediaCollection('transaction_file');

        $this->assertNotNull($collection);
        $this->assertEquals('transaction_file', $collection->name);
        $this->assertTrue($collection->singleFile);
    }

    /** @test */
    public function it_can_register_files_collection(): void
    {
        $exchangeRequest = new ExchangeRequest;
        $exchangeRequest->status = ExchangeRequest::STATUS_CREATED;

        $collection = $exchangeRequest->getMediaCollection('files');

        $this->assertNotNull($collection);
        $this->assertEquals('files', $collection->name);
        $this->assertFalse($collection->singleFile);
    }

    /** @test */
    public function it_accepts_only_allowed_file_types(): void
    {
        $exchangeRequest = new ExchangeRequest;
        $exchangeRequest->status = ExchangeRequest::STATUS_CREATED;

        $transactionFileCollection = $exchangeRequest->getMediaCollection('transaction_file');
        $filesCollection = $exchangeRequest->getMediaCollection('files');

        $allowedMimeTypes = [
            'application/pdf',
            'image/jpeg',
            'image/png',
            'image/jpg',
        ];

        foreach ($allowedMimeTypes as $mimeType) {
            $this->assertContains($mimeType, $transactionFileCollection->acceptsMimeTypes);
            $this->assertContains($mimeType, $filesCollection->acceptsMimeTypes);
        }
    }

    /** @test */
    public function it_has_methods_for_both_collections(): void
    {
        $exchangeRequest = new ExchangeRequest;

        // Test that methods exist
        $this->assertTrue(method_exists($exchangeRequest, 'getTransactionFile'));
        $this->assertTrue(method_exists($exchangeRequest, 'getFiles'));
        $this->assertTrue(method_exists($exchangeRequest, 'hasFiles'));
    }
}
