<?php

namespace Tests\Unit;

use PHPUnit\Framework\TestCase;

class CopilotInstructionsTest extends TestCase
{
    /**
     * Test that Copilot instructions file exists and contains required sections.
     */
    public function test_copilot_instructions_file_exists_and_has_required_content(): void
    {
        $instructionsPath = __DIR__.'/../../.github/copilot-instructions.md';

        $this->assertFileExists($instructionsPath, 'Copilot instructions file should exist');

        $content = file_get_contents($instructionsPath);

        // Test that required sections exist
        $requiredSections = [
            '# Copilot Instructions for Sekaya Laravel Project',
            '## Project Overview',
            '## Tech Stack',
            '## Architecture Patterns',
            '## Code Style & Conventions',
            '## Security Guidelines',
            '## Testing Approach',
            '## Database Guidelines',
            '## Common Patterns & Best Practices',
            '## Anti-Patterns to Avoid',
            '## File Organization',
            '## Development Workflow',
            '## Performance Considerations',
        ];

        foreach ($requiredSections as $section) {
            $this->assertStringContainsString(
                $section,
                $content,
                "Copilot instructions should contain section: {$section}"
            );
        }

        // Test that technology stack is mentioned
        $technologies = [
            'Laravel 12',
            'FilamentPHP',
            'Tailwind CSS',
            'Alpine.js',
            'Livewire',
            'MySQL',
            'PostgreSQL',
        ];

        foreach ($technologies as $tech) {
            $this->assertStringContainsString(
                $tech,
                $content,
                "Copilot instructions should mention technology: {$tech}"
            );
        }
    }

    /**
     * Test that README.md references the Copilot instructions.
     */
    public function test_readme_references_copilot_instructions(): void
    {
        $readmePath = __DIR__.'/../../README.md';
        $content = file_get_contents($readmePath);

        $this->assertStringContainsString(
            '.github/copilot-instructions.md',
            $content,
            'README should reference the Copilot instructions file'
        );

        $this->assertStringContainsString(
            'Copilot Instructions',
            $content,
            'README should have a Copilot Instructions section'
        );
    }
}
