<?php

namespace Tests\Feature;

use App\Models\Association;
use App\Models\Department;
use App\Models\User;
use Database\Seeders\RoleSeeder;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class UserSelectionFiltersTest extends TestCase
{
    use RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        $this->seed(RoleSeeder::class);
    }

    public function test_performance_card_assignees_only_shows_sekaya_employees(): void
    {
        // Create a Sekaya employee (no association_id)
        $sekayaEmployee = User::factory()->create([
            'name' => 'Sekaya Employee',
            'email' => 'employee@sekaya.com',
            'association_id' => null,
        ]);

        // Create an association and its representative
        $association = Association::factory()->create([
            'name' => 'Test Association',
        ]);

        $associationRep = User::factory()->create([
            'name' => 'Association Representative',
            'email' => 'rep@association.com',
            'association_id' => $association->id,
        ]);

        // Create a department
        $department = Department::factory()->create([
            'name' => 'Test Department',
        ]);

        // Test that only Sekaya employees are available for selection
        $availableUsers = User::whereNull('association_id')->pluck('name', 'id');

        $this->assertTrue($availableUsers->contains('Sekaya Employee'));
        $this->assertFalse($availableUsers->contains('Association Representative'));
    }

    public function test_admin_task_assigned_users_only_shows_sekaya_employees(): void
    {
        // Create a Sekaya employee (no association_id)
        $sekayaEmployee = User::factory()->create([
            'name' => 'Sekaya Employee',
            'email' => 'employee@sekaya.com',
            'association_id' => null,
        ]);

        // Create an association and its representative
        $association = Association::factory()->create([
            'name' => 'Test Association',
        ]);

        $associationRep = User::factory()->create([
            'name' => 'Association Representative',
            'email' => 'rep@association.com',
            'association_id' => $association->id,
        ]);

        // Test that only Sekaya employees are available for selection
        $availableUsers = User::whereNull('association_id')->pluck('name', 'id');

        $this->assertTrue($availableUsers->contains('Sekaya Employee'));
        $this->assertFalse($availableUsers->contains('Association Representative'));
    }

    public function test_department_users_only_shows_sekaya_employees(): void
    {
        // Create a Sekaya employee (no association_id)
        $sekayaEmployee = User::factory()->create([
            'name' => 'Sekaya Employee',
            'email' => 'employee@sekaya.com',
            'association_id' => null,
        ]);

        // Create an association and its representative
        $association = Association::factory()->create([
            'name' => 'Test Association',
        ]);

        $associationRep = User::factory()->create([
            'name' => 'Association Representative',
            'email' => 'rep@association.com',
            'association_id' => $association->id,
        ]);

        // Test that only Sekaya employees are available for selection
        $availableUsers = User::whereNull('association_id')->pluck('name', 'id');

        $this->assertTrue($availableUsers->contains('Sekaya Employee'));
        $this->assertFalse($availableUsers->contains('Association Representative'));
    }
}
