<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class TopbarGreetingTest extends TestCase
{
    use RefreshDatabase;

    public function test_topbar_greeting_blade_view_exists(): void
    {
        $this->assertTrue(view()->exists('filament.topbar-greeting'));
    }

    public function test_topbar_greeting_renders_correctly_when_user_is_authenticated(): void
    {
        // Create a test user
        $user = User::factory()->create([
            'name' => 'Test User',
            'email' => 'test@example.com',
        ]);

        // Simulate authentication
        $this->actingAs($user);

        // Render the view
        $view = view('filament.topbar-greeting');
        $content = $view->render();

        // Assert the greeting contains the user's name
        $this->assertStringContainsString('Hello Test User', $content);
    }

    public function test_topbar_greeting_renders_email_when_name_is_not_available(): void
    {
        // Create a test user without a name
        $user = User::factory()->create([
            'name' => null,
            'email' => 'test@example.com',
        ]);

        // Simulate authentication
        $this->actingAs($user);

        // Render the view
        $view = view('filament.topbar-greeting');
        $content = $view->render();

        // Assert the greeting contains the user's email
        $this->assertStringContainsString('Hello test@example.com', $content);
    }

    public function test_topbar_greeting_does_not_render_when_user_is_not_authenticated(): void
    {
        // Ensure no user is authenticated
        $this->assertGuest();

        // Render the view
        $view = view('filament.topbar-greeting');
        $content = $view->render();

        // Assert the greeting is not displayed
        $this->assertStringNotContainsString('Hello', $content);
    }
}
