<?php

namespace Tests\Feature;

use App\Filament\AssociationAdmin\Resources\AssociationOrderResource;
use App\Filament\Resources\OrderResource;
use Filament\Forms\Form;
use Tests\TestCase;

class OrderResourceWizardTest extends TestCase
{
    /** @test */
    public function test_order_resource_form_returns_wizard_structure()
    {
        $form = new Form;
        $orderForm = OrderResource::form($form);

        // Get the schema
        $schema = $orderForm->getSchema();

        // Verify we have exactly one component at root level (the Wizard)
        $this->assertCount(1, $schema);

        // Verify the root component is a Wizard
        $wizard = $schema[0];
        $this->assertInstanceOf(\Filament\Forms\Components\Wizard::class, $wizard);

        // Verify the wizard has steps
        $wizardSchema = $wizard->getChildComponents();
        $this->assertCount(5, $wizardSchema); // 5 steps

        // Verify each component is a Wizard Step
        foreach ($wizardSchema as $step) {
            $this->assertInstanceOf(\Filament\Forms\Components\Wizard\Step::class, $step);
        }
    }

    /** @test */
    public function test_association_order_resource_form_returns_wizard_structure()
    {
        $form = new Form;
        $orderForm = AssociationOrderResource::form($form);

        // Get the schema
        $schema = $orderForm->getSchema();

        // Verify we have exactly one component at root level (the Wizard)
        $this->assertCount(1, $schema);

        // Verify the root component is a Wizard
        $wizard = $schema[0];
        $this->assertInstanceOf(\Filament\Forms\Components\Wizard::class, $wizard);

        // Verify the wizard has steps
        $wizardSchema = $wizard->getChildComponents();
        $this->assertCount(5, $wizardSchema); // 5 steps

        // Verify each component is a Wizard Step
        foreach ($wizardSchema as $step) {
            $this->assertInstanceOf(\Filament\Forms\Components\Wizard\Step::class, $step);
        }
    }

    /** @test */
    public function test_wizard_steps_have_expected_labels()
    {
        $form = new Form;
        $orderForm = OrderResource::form($form);

        $schema = $orderForm->getSchema();
        $wizard = $schema[0];
        $wizardSteps = $wizard->getChildComponents();

        // Note: We can't easily test translation keys without full Laravel setup,
        // but we can verify the structure exists
        $this->assertCount(5, $wizardSteps);

        // Each step should have a label (though it will be a translation key)
        foreach ($wizardSteps as $step) {
            $this->assertNotEmpty($step->getLabel());
        }
    }

    /** @test */
    public function test_wizard_preserves_required_fields()
    {
        // Verify that key required fields are still present in the wizard
        $form = new Form;
        $orderForm = OrderResource::form($form);

        $schema = $orderForm->getSchema();
        $wizard = $schema[0];
        $wizardSteps = $wizard->getChildComponents();

        // Flatten all fields from all steps
        $allFields = [];
        foreach ($wizardSteps as $step) {
            $stepFields = $step->getChildComponents();
            $allFields = array_merge($allFields, $stepFields);
        }

        // Check for key field names
        $fieldNames = array_map(function ($field) {
            return $field->getName();
        }, $allFields);

        // Verify essential fields are present
        $requiredFields = ['association_id', 'name', 'type', 'state_id', 'city_id', 'water_source', 'water_distance'];

        foreach ($requiredFields as $requiredField) {
            $this->assertContains($requiredField, $fieldNames, "Required field {$requiredField} not found in wizard");
        }
    }
}
