<?php

namespace Tests\Feature;

use App\Filament\Pages\FinancialPortfoliosDashboard;
use Tests\TestCase;

class FinancialPortfoliosDashboardTest extends TestCase
{
    public function test_dashboard_has_correct_navigation_label(): void
    {
        $expectedLabel = __('pages.financial_portfolios_dashboard');
        $this->assertEquals($expectedLabel, FinancialPortfoliosDashboard::getNavigationLabel());
    }

    public function test_dashboard_has_widgets(): void
    {
        $dashboard = new FinancialPortfoliosDashboard;
        $widgets = $dashboard->getWidgets();

        $this->assertNotEmpty($widgets);
        $this->assertContains(\App\Filament\Widgets\FinancialPortfoliosStatsOverview::class, $widgets);
        $this->assertContains(\App\Filament\Widgets\FinancialPortfoliosValueChart::class, $widgets);
        $this->assertContains(\App\Filament\Widgets\FinancialPortfoliosExpensesChart::class, $widgets);
        $this->assertContains(\App\Filament\Widgets\FinancialPortfoliosStatusTable::class, $widgets);
    }

    public function test_widgets_can_be_instantiated(): void
    {
        // Test that all widgets can be instantiated without errors
        $this->assertInstanceOf(\App\Filament\Widgets\FinancialPortfoliosStatsOverview::class,
            new \App\Filament\Widgets\FinancialPortfoliosStatsOverview);

        $this->assertInstanceOf(\App\Filament\Widgets\FinancialPortfoliosValueChart::class,
            new \App\Filament\Widgets\FinancialPortfoliosValueChart);

        $this->assertInstanceOf(\App\Filament\Widgets\FinancialPortfoliosExpensesChart::class,
            new \App\Filament\Widgets\FinancialPortfoliosExpensesChart);

        $this->assertInstanceOf(\App\Filament\Widgets\FinancialPortfoliosStatusTable::class,
            new \App\Filament\Widgets\FinancialPortfoliosStatusTable);
    }

    public function test_language_keys_exist(): void
    {
        // Test that required language keys exist
        $this->assertNotEquals('pages.financial_portfolios_dashboard', __('pages.financial_portfolios_dashboard'));
        $this->assertNotEquals('widgets.total_financial_portfolios', __('widgets.total_financial_portfolios'));
        $this->assertNotEquals('widgets.financial_portfolios_values', __('widgets.financial_portfolios_values'));
        $this->assertNotEquals('widgets.financial_portfolios_status', __('widgets.financial_portfolios_status'));
    }
}
