<?php

namespace Tests\Feature;

use App\Enums\AssociationType;
use App\Models\Association;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class AssociationTypeTest extends TestCase
{
    use RefreshDatabase;

    public function test_association_can_be_created_with_type(): void
    {
        $association = Association::factory()->create([
            'type' => AssociationType::ASSOCIATION,
        ]);

        $this->assertInstanceOf(AssociationType::class, $association->type);
        $this->assertEquals(AssociationType::ASSOCIATION, $association->type);
    }

    public function test_association_defaults_to_association_type(): void
    {
        $association = Association::factory()->create();

        $this->assertInstanceOf(AssociationType::class, $association->type);
        $this->assertEquals(AssociationType::ASSOCIATION, $association->type);
    }

    public function test_association_can_be_institution_type(): void
    {
        $association = Association::factory()->create([
            'type' => AssociationType::INSTITUTION,
        ]);

        $this->assertEquals(AssociationType::INSTITUTION, $association->type);
    }

    public function test_association_can_be_endowment_type(): void
    {
        $association = Association::factory()->create([
            'type' => AssociationType::ENDOWMENT,
        ]);

        $this->assertEquals(AssociationType::ENDOWMENT, $association->type);
    }

    public function test_association_type_enum_has_correct_labels(): void
    {
        $this->assertEquals('جمعية', AssociationType::ASSOCIATION->getLabel());
        $this->assertEquals('مؤسسة', AssociationType::INSTITUTION->getLabel());
        $this->assertEquals('وقف', AssociationType::ENDOWMENT->getLabel());
    }

    public function test_association_type_enum_has_correct_colors(): void
    {
        $this->assertEquals('success', AssociationType::ASSOCIATION->getColor());
        $this->assertEquals('info', AssociationType::INSTITUTION->getColor());
        $this->assertEquals('warning', AssociationType::ENDOWMENT->getColor());
    }

    public function test_association_type_enum_get_options_returns_array(): void
    {
        $options = AssociationType::getOptions();

        $this->assertIsArray($options);
        $this->assertCount(3, $options);
        $this->assertArrayHasKey('association', $options);
        $this->assertArrayHasKey('institution', $options);
        $this->assertArrayHasKey('endowment', $options);
    }
}
