<?php

use App\Http\Controllers\OrderController;
use App\Livewire\RegisterAssociation;
use Illuminate\Support\Facades\Route;

Route::get('/register-association', RegisterAssociation::class)
    ->name('register.association');

Route::get('/association/pending-approval', function () {
    return view('association.pending-approval');
})
    ->middleware('association.approval')
    ->name('association.pending-approval');

// Order routes for admin users
// Test route for well permit preview
Route::get('/well-permit-preview', function () {
    return view('well-permit', [
        // License Title
        'license_title_ar' => 'رخصة بئر أنبوبي',
        'license_title_en' => 'Well License Certificate',

        // License Information
        'ministry_license_number' => 'ML-2024-12345',
        'ministry_license_start_date' => \Carbon\Carbon::parse('2024-01-15'),
        'ministry_license_end_date' => \Carbon\Carbon::parse('2029-01-14'),

        // Association Information
        'association_name' => 'جمعية المياه الزراعية النموذجية',
        'association_license_number' => 'AL-2023-67890',

        // Location Information
        'state' => 'منطقة الرياض',
        'city' => 'الرياض',
        'center' => 'مركز الدرعية',
    ]);
})->name('well-permit.preview');

Route::middleware(['auth'])->group(function () {
    Route::apiResource('orders', OrderController::class);
    Route::post('orders/{order}/files', [OrderController::class, 'uploadFile'])->name('orders.upload-file');
    Route::delete('orders/{order}/files/{fileId}', [OrderController::class, 'deleteFile'])->name('orders.delete-file');
    Route::put('orders/{order}/files/{fileId}/title', [OrderController::class, 'updateFileTitle'])->name('orders.update-file-title');
});
