<div class="flex min-h-screen" style="font-family: 'Noto Sans Arabic', sans-serif;">
    <!-- Language switcher outside panels -->
    <livewire:filament-language-switch key='fls-outside-panels' />

    <!-- Left side image (hidden on small screens, visible on lg+) -->
    @php
        $bgImage = Vite::asset('resources/images/auth-bg.svg');
    @endphp

    <div class="w-1/2 hidden lg:block bg-bottom bg-no-repeat bg-cover" style="background-image: url('{{ $bgImage }}');">
    </div>

    <!-- Right side form container -->
    <div class="w-full lg:w-1/2 p-16">
        <!-- Header -->
        <div class="">
            <h3 class="text-midnightBlue text-2xl font-semibold mb-2">
                {{ __('association.page_title') }}
            </h3>

            <span class="text-gray-500 text-base">
                {{ __('association.page_subtitle') }}
            </span>
        </div>

        @if (session()->has('success'))
            <div class="mt-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded-lg">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-green-400" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                clip-rule="evenodd" />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium">
                            {{ session('success') }}
                        </p>
                    </div>
                </div>
            </div>
        @endif

        <!-- Form -->
        <div class="mt-8">
            <form wire:submit.prevent="submit">
                {{ $this->form }}

                <!-- Flash Messages -->
        @if (session()->has('error'))
            <div class="mt-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded-lg">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                clip-rule="evenodd" />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium">
                            {{ session('error') }}
                        </p>
                    </div>
                </div>
            </div>
        @endif
        
                <x-filament::button type="submit" class="w-full mt-8 !bg-blue hover:bg-blue/80" size="xl">
                    {{ __('association.register') }}
                </x-filament::button>
            </form>

            <div class="flex justify-center gap-2 mt-4 text-sm">
                <span class="font-semibold text-gray-700">
                    {{ __('association.already_have_account') }}
                </span>

                <a href="{{ route('filament.association-admin.auth.login') }}"
                    class="text-blue font-bold cursor-pointer hover:underline">
                    {{ __('association.login') }}
                </a>
            </div>
        </div>
    </div>

    <livewire:otp-form-modal />
</div>