<div class="flex min-h-screen" style="font-family: 'Noto Sans Arabic', sans-serif;">
    <!-- Language switcher outside panels -->
    <livewire:filament-language-switch key='fls-outside-panels' />

    <!-- Left side image (hidden on small screens, visible on lg+) -->
    @php
        $bgImage = Vite::asset('resources/images/auth-bg.svg');
    @endphp

    <div class="w-1/2 hidden lg:block bg-bottom bg-no-repeat bg-cover" style="background-image: url('{{ $bgImage }}');">
    </div>

    <!-- Right side form container -->
    <div class="w-full lg:w-1/2 p-16 flex items-center">
        <div class="flex-1">
            <!-- Header -->
            <div class="">
                <h3 class="text-midnightBlue text-2xl font-semibold mb-2">
                    {{ __('auth.title') }}
                </h3>

                <span class="text-gray-500 text-base">
                    {{ __('auth.subtitle') }}
                </span>
            </div>

            <!-- Form -->
            <div class="mt-8">
                <form wire:submit.prevent="submit">
                    {{ $this->form }}

                    <x-filament::button type="submit" class="w-full mt-4 !bg-blue hover:bg-blue/80" size="xl">
                        {{ __('association.login') }}
                    </x-filament::button>
                </form>

                <div class="flex justify-center gap-2 mt-4 text-sm">
                    <span class="font-semibold text-gray-700">
                        {{ __('auth.no_account') }}
                    </span>

                    <a href="{{ route('register.association') }}"
                        class="text-blue font-bold cursor-pointer hover:underline">
                        {{ __('association.register') }}
                    </a>
                </div>
                <div class="flex justify-center gap-2 mt-4 text-sm">
                    <a target="_blank"
                        href="https://sekaya-prod-api.fra1.digitaloceanspaces.com/sekaya-templates/%D8%AF%D9%84%D9%8A%D9%84%20%D8%A7%D9%84%D9%85%D8%B3%D8%AA%D8%AE%D8%AF%D9%85%20-%20%D9%85%D9%86%D8%B5%D8%A9%20%D8%B3%D9%82%D8%A7%D9%8A%D8%A9%20v5.pdf"
                        class="text-blue font-bold cursor-pointer hover:underline">
                        {{ 'دليل المستخدم' }}
                    </a>
                </div>
                <div class="flex justify-center mt-4 text-sm text-center">
                    <div class="text-gray-600">
                        <div class="mb-1">للاستفسارات أو رفع تذكرة دعم فني، يُرجى التواصل عبر البريد الإلكتروني:</div>
                        <a href="mailto:CS@sekaya.org.sa" class="text-blue font-bold cursor-pointer hover:underline">
                            CS@sekaya.org.sa
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <livewire:otp-form-modal />
</div>