<x-filament::modal id="otp-modal" width="sm">
    <x-slot name="heading">
        {{ __('otp.one_time_password') }}
    </x-slot>

    <div class="space-y-4">
        <form wire:submit.prevent="submit">
            <div x-data="{
                otp: Array(6).fill(''),
                focusNext(index, event) {
                    if (event.inputType === 'deleteContentBackward') return;
            
                    const next = document.getElementById(`otp-${index + 1}`);
                    if (next) next.focus();
                },
                focusPrev(index, event) {
                    if (event.key !== 'Backspace') return;
            
                    const prev = document.getElementById(`otp-${index - 1}`);
                    if (prev && !event.target.value) prev.focus();
                },
                updateLivewire() {
                    $wire.otp = this.otp.join('');
                },
                clearInputs() {
                    this.otp = Array(6).fill('');
                    $wire.otp = null;
                }
            }" 
            x-init="
                $watch('otp', () => updateLivewire());
                Livewire.on('clearOtpInputs', () => clearInputs());
            " 
            class="flex flex-col items-center space-y-4">
                <div class="flex space-x-2" style="direction: ltr;gap: 0.5rem;">
                    <template x-for="(digit, index) in otp" :key="index">
                        <input :id="`otp-${index}`" type="text" maxlength="1"
                            class="w-12 h-12 text-center text-xl border rounded" x-model="otp[index]"
                            style="width: 3rem; height: 3rem;"
                            @input="focusNext(index, $event)" @keydown="focusPrev(index, $event)" />
                    </template>
                </div>
            </div>

            @error('otp')
                <p class="text-red-600 text-sm mt-1">{{ $message }}</p>
            @enderror

            <x-filament::button type="submit" class="!bg-blue hover:!bg-blue/80 mt-4">
                {{ __('otp.verify') }}
            </x-filament::button>
        </form>

    </div>
</x-filament::modal>