<div class="">
    <x-filament::modal id="terms-and-conditions" width="lg" alignment="center" :close-button="false" :close-by-escaping="false"
        :close-by-clicking-away="false" :autofocus="false">
        <div class="">
            <h2 class="text-lg font-semibold mb-4">
                {{ __('terms-and-conditions-modal.title') }}
            </h2>

            <hr class="border-gray-300 dark:border-gray-700">

            <div
                class="bg-zinc-100 dark:bg-zinc-900 py-6 rounded-xl w-2xl mx-auto text-gray-800 text-sm overflow-y-auto space-y-2 max-h-[400px]">
                <div class="">
                    <p class="">
                        {{ __('terms-and-conditions-modal.intro.welcome') }}
                    </p>
                    <p>
                        {{ __('terms-and-conditions-modal.intro.consent') }}
                    </p>
                </div>

                <div class="">
                    <p class="font-bold text-gray-900">{{ __('terms-and-conditions-modal.sections.acceptance.title') }}
                    </p>
                    <p>
                        {{ __('terms-and-conditions-modal.sections.acceptance.text') }}
                    </p>
                </div>

                <div class="">
                    <p class="font-bold text-gray-900">{{ __('terms-and-conditions-modal.sections.usage.title') }}
                    </p>
                    <p>
                        {{ __('terms-and-conditions-modal.sections.usage.text') }}
                    </p>
                </div>

                <div class="">
                    <p class="font-bold text-gray-900">
                        {{ __('terms-and-conditions-modal.sections.intellectual_property.title') }}
                    </p>
                    <p>
                        {{ __('terms-and-conditions-modal.sections.intellectual_property.text') }}
                    </p>
                </div>

                <div class="">
                    <p class="font-bold text-gray-900">
                        {{ __('terms-and-conditions-modal.sections.account.title') }}
                    </p>
                    <p>
                        {{ __('terms-and-conditions-modal.sections.account.text') }}
                    </p>
                </div>

                <div class="">
                    <p class="font-bold text-gray-900">
                        {{ __('terms-and-conditions-modal.sections.privacy.title') }}
                    </p>
                    <p>
                        {{ __('terms-and-conditions-modal.sections.privacy.text.first_part') }}
                        <a href="#" class="text-blue text-underline">
                            {{ __('terms-and-conditions-modal.sections.privacy.text.link_text') }}
                        </a>
                    </p>
                </div>
            </div>

            <hr class="border-gray-300 dark:border-gray-700">

            <x-filament::button class="mt-6 w-full bg-primary hover:bg-blue/80" size="xl" wire:click="submit">
                {{ __('terms-and-conditions-modal.accept_button') }}
            </x-filament::button>
        </div>
    </x-filament::modal>

    <div class="" x-init="$dispatch('open-modal', { id: 'terms-and-conditions' })"></div>
</div>
