<div class="flex min-h-screen" style="font-family: 'Noto Sans Arabic', sans-serif;">
    <!-- Language switcher outside panels -->
    <livewire:filament-language-switch key='fls-outside-panels' />

    <!-- Left side image (hidden on small screens, visible on lg+) -->
    @php
        $bgImage = Vite::asset('resources/images/auth-bg.svg');
    @endphp

    <div class="w-1/2 hidden lg:block bg-bottom bg-no-repeat bg-cover" style="background-image: url('{{ $bgImage }}');">
    </div>

    <!-- Right side form container -->
    <div class="w-full lg:w-1/2 p-16 flex items-center">
        <div class="flex-1">
            <!-- Header -->
            <div class="">
                <h3 class="text-midnightBlue text-2xl font-semibold mb-2">
                    {{ __('auth.title') }}
                </h3>

                <span class="text-gray-500 text-base">
                    {{ __('auth.admins_subtitle') }}
                </span>
            </div>

            <!-- Form -->
            <div class="mt-8">
                <form wire:submit.prevent="submit">
                    {{ $this->form }}

                    <x-filament::button type="submit" class="w-full mt-4 !bg-blue hover:bg-blue/80" size="xl">
                        {{ __('association.login') }}
                    </x-filament::button>
                </form>
            </div>
        </div>
    </div>

    <livewire:otp-form-modal />
</div>