@props([
    'modalId' => 'license-terms-modal',
])

<x-filament::modal
    :id="$modalId"
    width="3xl"
    alignment="center"
    :close-button="false"
    :close-by-escaping="false"
    :close-by-clicking-away="false"
>
    <x-slot name="heading">
        <div class="text-xl font-bold">
            {{ __('license_terms.title') }}
        </div>
    </x-slot>

    <div class="space-y-6">
        {{-- Introduction --}}
        <div class="prose dark:prose-invert max-w-none">
            <p class="text-sm text-gray-600 dark:text-gray-400">
                {{ __('license_terms.intro') }}
            </p>
        </div>

        {{-- Terms Content --}}
        <div class="bg-gray-50 dark:bg-gray-900 rounded-lg p-6 max-h-[500px] overflow-y-auto space-y-6">
            {{-- Data Accuracy --}}
            <div class="space-y-2">
                <h3 class="text-base font-semibold text-gray-900 dark:text-gray-100">
                    {{ __('license_terms.sections.data_accuracy.title') }}
                </h3>
                <p class="text-sm text-gray-700 dark:text-gray-300">
                    {{ __('license_terms.sections.data_accuracy.content') }}
                </p>
            </div>

            {{-- Legal Compliance --}}
            <div class="space-y-2">
                <h3 class="text-base font-semibold text-gray-900 dark:text-gray-100">
                    {{ __('license_terms.sections.legal_compliance.title') }}
                </h3>
                <p class="text-sm text-gray-700 dark:text-gray-300">
                    {{ __('license_terms.sections.legal_compliance.content') }}
                </p>
            </div>

            {{-- Documentation Requirements --}}
            <div class="space-y-2">
                <h3 class="text-base font-semibold text-gray-900 dark:text-gray-100">
                    {{ __('license_terms.sections.documentation.title') }}
                </h3>
                <p class="text-sm text-gray-700 dark:text-gray-300">
                    {{ __('license_terms.sections.documentation.content') }}
                </p>
            </div>

            {{-- Information Verification --}}
            <div class="space-y-2">
                <h3 class="text-base font-semibold text-gray-900 dark:text-gray-100">
                    {{ __('license_terms.sections.verification.title') }}
                </h3>
                <p class="text-sm text-gray-700 dark:text-gray-300">
                    {{ __('license_terms.sections.verification.content') }}
                </p>
            </div>

            {{-- Responsibilities --}}
            <div class="space-y-2">
                <h3 class="text-base font-semibold text-gray-900 dark:text-gray-100">
                    {{ __('license_terms.sections.responsibilities.title') }}
                </h3>
                <ul class="text-sm text-gray-700 dark:text-gray-300 list-disc list-inside space-y-1">
                    <li>{{ __('license_terms.sections.responsibilities.items.accuracy') }}</li>
                    <li>{{ __('license_terms.sections.responsibilities.items.updates') }}</li>
                    <li>{{ __('license_terms.sections.responsibilities.items.compliance') }}</li>
                    <li>{{ __('license_terms.sections.responsibilities.items.cooperation') }}</li>
                </ul>
            </div>

            {{-- Approval Process --}}
            <div class="space-y-2">
                <h3 class="text-base font-semibold text-gray-900 dark:text-gray-100">
                    {{ __('license_terms.sections.approval.title') }}
                </h3>
                <p class="text-sm text-gray-700 dark:text-gray-300">
                    {{ __('license_terms.sections.approval.content') }}
                </p>
            </div>

            {{-- Consequences --}}
            <div class="space-y-2">
                <h3 class="text-base font-semibold text-gray-900 dark:text-gray-100">
                    {{ __('license_terms.sections.consequences.title') }}
                </h3>
                <p class="text-sm text-gray-700 dark:text-gray-300">
                    {{ __('license_terms.sections.consequences.content') }}
                </p>
            </div>
        </div>

        {{-- Agreement Checkbox --}}
        <div class="flex items-start gap-3 p-4 bg-primary-50 dark:bg-primary-900/20 rounded-lg">
            <input
                type="checkbox"
                id="terms-agreement-{{ $modalId }}"
                class="mt-1 rounded border-gray-300 text-primary-600 shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-200 focus:ring-opacity-50"
                wire:model="termsAccepted"
            />
            <label for="terms-agreement-{{ $modalId }}" class="text-sm text-gray-700 dark:text-gray-300 cursor-pointer">
                {{ __('license_terms.agreement') }}
            </label>
        </div>
    </div>

    <x-slot name="footerActions">
        <x-filament::button
            color="primary"
            size="lg"
            class="w-full"
            wire:click="acceptTermsAndProceed"
            :disabled="!$this->termsAccepted"
        >
            {{ __('license_terms.accept_and_continue') }}
        </x-filament::button>
    </x-slot>
</x-filament::modal>
