@php
    $results = $getRecord()->results;
@endphp

<div class="space-y-4">
    @if($results->isEmpty())
        <div class="text-gray-500 text-center py-8">
            <svg class="w-12 h-12 mx-auto mb-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z">
                </path>
            </svg>
            <p class="text-sm">{{ __('initiative_result.no_results_yet') }}</p>
        </div>
    @else
        <div class="max-h-96 overflow-y-auto space-y-4">
            @foreach($results as $result)
                <div
                    class="border rounded-lg p-4 bg-gray-50 dark:bg-gray-800 hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 relative">
                    {{-- Action buttons (always visible at top-end) --}}
                    <div class="absolute top-2 end-2 flex space-x-1 z-10">
                        {{-- Edit button --}}
                        <button type="button"
                            wire:click="mountAction('editResult', {{ json_encode(['result' => $result->id]) }})"
                            class="p-1.5 text-blue-600 hover:text-blue-800 hover:bg-blue-100 dark:hover:bg-blue-900 rounded-md transition-colors duration-200 bg-white dark:bg-gray-700 shadow-sm border border-gray-200 dark:border-gray-600"
                            title="{{ __('filament-actions::edit.single.label') }}">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                </path>
                            </svg>
                        </button>

                        {{-- Delete button --}}
                        <button type="button"
                            wire:click="mountAction('deleteResult', {{ json_encode(['result' => $result->id]) }})"
                            class="p-1.5 text-red-600 hover:text-red-800 hover:bg-red-100 dark:hover:bg-red-900 rounded-md transition-colors duration-200 bg-white dark:bg-gray-700 shadow-sm border border-gray-200 dark:border-gray-600"
                            title="{{ __('filament-actions::delete.single.label') }}">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                </path>
                            </svg>
                        </button>
                    </div>

                    <div class="pt-4">
                        {{-- Quarterly Results Header --}}
                        <div class="mb-4">
                            <h4 class="text-sm font-semibold text-gray-900 dark:text-gray-100 mb-2">
                                {{ __('initiative_result.quarterly_targets') }}
                            </h4>
                        </div>

                        {{-- Quarterly Results Grid --}}
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                            {{-- Q1 --}}
                            <div class="bg-white dark:bg-gray-700 rounded-lg p-3 border border-gray-200 dark:border-gray-600">
                                <div class="text-xs font-medium text-gray-500 dark:text-gray-400 mb-2">
                                    {{ __('initiative_result.q1') }}
                                </div>
                                <div class="space-y-2">
                                    <div class="flex justify-between items-center">
                                        <span
                                            class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.expected') }}:</span>
                                        <span class="text-sm font-medium text-blue-600 dark:text-blue-400">
                                            {{ $result->expected_q1 ? number_format($result->expected_q1, 2) : '—' }}
                                        </span>
                                    </div>
                                    <div class="flex justify-between items-center">
                                        <span
                                            class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.actual') }}:</span>
                                        <span
                                            class="text-sm font-medium {{ $result->actual_q1 ? 'text-green-600 dark:text-green-400' : 'text-gray-400' }}">
                                            {{ $result->actual_q1 ? number_format($result->actual_q1, 2) : '—' }}
                                        </span>
                                    </div>
                                </div>
                            </div>

                            {{-- Q2 --}}
                            <div class="bg-white dark:bg-gray-700 rounded-lg p-3 border border-gray-200 dark:border-gray-600">
                                <div class="text-xs font-medium text-gray-500 dark:text-gray-400 mb-2">
                                    {{ __('initiative_result.q2') }}
                                </div>
                                <div class="space-y-2">
                                    <div class="flex justify-between items-center">
                                        <span
                                            class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.expected') }}:</span>
                                        <span class="text-sm font-medium text-blue-600 dark:text-blue-400">
                                            {{ $result->expected_q2 ? number_format($result->expected_q2, 2) : '—' }}
                                        </span>
                                    </div>
                                    <div class="flex justify-between items-center">
                                        <span
                                            class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.actual') }}:</span>
                                        <span
                                            class="text-sm font-medium {{ $result->actual_q2 ? 'text-green-600 dark:text-green-400' : 'text-gray-400' }}">
                                            {{ $result->actual_q2 ? number_format($result->actual_q2, 2) : '—' }}
                                        </span>
                                    </div>
                                </div>
                            </div>

                            {{-- Q3 --}}
                            <div class="bg-white dark:bg-gray-700 rounded-lg p-3 border border-gray-200 dark:border-gray-600">
                                <div class="text-xs font-medium text-gray-500 dark:text-gray-400 mb-2">
                                    {{ __('initiative_result.q3') }}
                                </div>
                                <div class="space-y-2">
                                    <div class="flex justify-between items-center">
                                        <span
                                            class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.expected') }}:</span>
                                        <span class="text-sm font-medium text-blue-600 dark:text-blue-400">
                                            {{ $result->expected_q3 ? number_format($result->expected_q3, 2) : '—' }}
                                        </span>
                                    </div>
                                    <div class="flex justify-between items-center">
                                        <span
                                            class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.actual') }}:</span>
                                        <span
                                            class="text-sm font-medium {{ $result->actual_q3 ? 'text-green-600 dark:text-green-400' : 'text-gray-400' }}">
                                            {{ $result->actual_q3 ? number_format($result->actual_q3, 2) : '—' }}
                                        </span>
                                    </div>
                                </div>
                            </div>

                            {{-- Q4 --}}
                            <div class="bg-white dark:bg-gray-700 rounded-lg p-3 border border-gray-200 dark:border-gray-600">
                                <div class="text-xs font-medium text-gray-500 dark:text-gray-400 mb-2">
                                    {{ __('initiative_result.q4') }}
                                </div>
                                <div class="space-y-2">
                                    <div class="flex justify-between items-center">
                                        <span
                                            class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.expected') }}:</span>
                                        <span class="text-sm font-medium text-blue-600 dark:text-blue-400">
                                            {{ $result->expected_q4 ? number_format($result->expected_q4, 2) : '—' }}
                                        </span>
                                    </div>
                                    <div class="flex justify-between items-center">
                                        <span
                                            class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.actual') }}:</span>
                                        <span
                                            class="text-sm font-medium {{ $result->actual_q4 ? 'text-green-600 dark:text-green-400' : 'text-gray-400' }}">
                                            {{ $result->actual_q4 ? number_format($result->actual_q4, 2) : '—' }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- Performance Card Results --}}
                        @if($result->performanceCardResults->isNotEmpty())
                            <div class="border-t border-gray-200 dark:border-gray-600 pt-3">
                                <div class="text-xs font-medium text-gray-500 dark:text-gray-400 mb-2">
                                    {{ __('initiative_result.linked_performance_results') }}
                                </div>
                                <div class="flex flex-wrap gap-1">
                                    @foreach($result->performanceCardResults as $pcResult)
                                        <span
                                            class="inline-flex items-center px-2 py-1 rounded-full text-xs bg-indigo-100 dark:bg-indigo-900 text-indigo-700 dark:text-indigo-300">
                                            {{ $pcResult->result }}
                                        </span>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    @endif
</div>

{{-- Action Modals --}}
<x-filament-actions::modals />