@php
    $performanceCard = $getRecord();

    // Get all initiatives related to this performance card
    $initiatives = $performanceCard->initiatives;

    // Aggregate quarterly data from all initiative results
    $aggregatedData = [
        'expected_q1' => 0,
        'actual_q1' => 0,
        'expected_q2' => 0,
        'actual_q2' => 0,
        'expected_q3' => 0,
        'actual_q3' => 0,
        'expected_q4' => 0,
        'actual_q4' => 0,
    ];

    $resultsByPerformanceCardResult = [];

    foreach ($initiatives as $initiative) {
        foreach ($initiative->results as $result) {
            // Aggregate quarterly totals
            $aggregatedData['expected_q1'] += $result->expected_q1 ?? 0;
            $aggregatedData['actual_q1'] += $result->actual_q1 ?? 0;
            $aggregatedData['expected_q2'] += $result->expected_q2 ?? 0;
            $aggregatedData['actual_q2'] += $result->actual_q2 ?? 0;
            $aggregatedData['expected_q3'] += $result->expected_q3 ?? 0;
            $aggregatedData['actual_q3'] += $result->actual_q3 ?? 0;
            $aggregatedData['expected_q4'] += $result->expected_q4 ?? 0;
            $aggregatedData['actual_q4'] += $result->actual_q4 ?? 0;

            // Group results by performance card result for individual cards
            foreach ($result->performanceCardResults as $pcr) {
                $key = $pcr->id;
                if (!isset($resultsByPerformanceCardResult[$key])) {
                    $resultsByPerformanceCardResult[$key] = [
                        'performance_card_result' => $pcr,
                        'expected_q1' => 0,
                        'actual_q1' => 0,
                        'expected_q2' => 0,
                        'actual_q2' => 0,
                        'expected_q3' => 0,
                        'actual_q3' => 0,
                        'expected_q4' => 0,
                        'actual_q4' => 0,
                    ];
                }

                $resultsByPerformanceCardResult[$key]['expected_q1'] += $result->expected_q1 ?? 0;
                $resultsByPerformanceCardResult[$key]['actual_q1'] += $result->actual_q1 ?? 0;
                $resultsByPerformanceCardResult[$key]['expected_q2'] += $result->expected_q2 ?? 0;
                $resultsByPerformanceCardResult[$key]['actual_q2'] += $result->actual_q2 ?? 0;
                $resultsByPerformanceCardResult[$key]['expected_q3'] += $result->expected_q3 ?? 0;
                $resultsByPerformanceCardResult[$key]['actual_q3'] += $result->actual_q3 ?? 0;
                $resultsByPerformanceCardResult[$key]['expected_q4'] += $result->expected_q4 ?? 0;
                $resultsByPerformanceCardResult[$key]['actual_q4'] += $result->actual_q4 ?? 0;
            }
        }
    }
@endphp

<div class="space-y-6">

    {{-- Individual Performance Card Result Cards --}}
    @if(!empty($resultsByPerformanceCardResult))
        <div class="space-y-4">
            <h4 class="text-lg font-semibold text-gray-900 dark:text-gray-100 flex items-center">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M9 5H7a2 2 0 00-2 2v6a2 2 0 002 2h6a2 2 0 002-2V7a2 2 0 00-2-2H9z"></path>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M15 12h6v6a2 2 0 01-2 2h-6v-8z"></path>
                </svg>
                {{ __('performance_card.results_by_category') }}
            </h4>

            @foreach($resultsByPerformanceCardResult as $data)
                <div
                    class="border rounded-lg p-4 bg-gray-50 dark:bg-gray-800 hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200">
                    <div class="mb-4">
                        <h5 class="text-md font-semibold text-gray-900 dark:text-gray-100 mb-1">
                            {{ $data['performance_card_result']->result }}
                        </h5>
                        <p class="text-sm text-gray-600 dark:text-gray-400">
                            {{ __('performance_card.aggregated_from_initiatives') }}
                        </p>
                    </div>

                    {{-- Quarterly Results Grid for this specific result --}}
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                        {{-- Q1 --}}
                        <div class="bg-white dark:bg-gray-700 rounded-lg p-3 border border-gray-200 dark:border-gray-600">
                            <div class="text-xs font-medium text-gray-500 dark:text-gray-400 mb-2">
                                {{ __('initiative_result.q1') }}
                            </div>
                            <div class="space-y-1">
                                <div class="flex justify-between items-center">
                                    <span
                                        class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.expected') }}:</span>
                                    <span class="text-sm font-medium text-blue-600 dark:text-blue-400">
                                        {{ number_format($data['expected_q1'], 2) }}
                                    </span>
                                </div>
                                <div class="flex justify-between items-center">
                                    <span
                                        class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.actual') }}:</span>
                                    <span class="text-sm font-medium text-green-600 dark:text-green-400">
                                        {{ number_format($data['actual_q1'], 2) }}
                                    </span>
                                </div>
                            </div>
                        </div>

                        {{-- Q2 --}}
                        <div class="bg-white dark:bg-gray-700 rounded-lg p-3 border border-gray-200 dark:border-gray-600">
                            <div class="text-xs font-medium text-gray-500 dark:text-gray-400 mb-2">
                                {{ __('initiative_result.q2') }}
                            </div>
                            <div class="space-y-1">
                                <div class="flex justify-between items-center">
                                    <span
                                        class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.expected') }}:</span>
                                    <span class="text-sm font-medium text-blue-600 dark:text-blue-400">
                                        {{ number_format($data['expected_q2'], 2) }}
                                    </span>
                                </div>
                                <div class="flex justify-between items-center">
                                    <span
                                        class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.actual') }}:</span>
                                    <span class="text-sm font-medium text-green-600 dark:text-green-400">
                                        {{ number_format($data['actual_q2'], 2) }}
                                    </span>
                                </div>
                            </div>
                        </div>

                        {{-- Q3 --}}
                        <div class="bg-white dark:bg-gray-700 rounded-lg p-3 border border-gray-200 dark:border-gray-600">
                            <div class="text-xs font-medium text-gray-500 dark:text-gray-400 mb-2">
                                {{ __('initiative_result.q3') }}
                            </div>
                            <div class="space-y-1">
                                <div class="flex justify-between items-center">
                                    <span
                                        class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.expected') }}:</span>
                                    <span class="text-sm font-medium text-blue-600 dark:text-blue-400">
                                        {{ number_format($data['expected_q3'], 2) }}
                                    </span>
                                </div>
                                <div class="flex justify-between items-center">
                                    <span
                                        class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.actual') }}:</span>
                                    <span class="text-sm font-medium text-green-600 dark:text-green-400">
                                        {{ number_format($data['actual_q3'], 2) }}
                                    </span>
                                </div>
                            </div>
                        </div>

                        {{-- Q4 --}}
                        <div class="bg-white dark:bg-gray-700 rounded-lg p-3 border border-gray-200 dark:border-gray-600">
                            <div class="text-xs font-medium text-gray-500 dark:text-gray-400 mb-2">
                                {{ __('initiative_result.q4') }}
                            </div>
                            <div class="space-y-1">
                                <div class="flex justify-between items-center">
                                    <span
                                        class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.expected') }}:</span>
                                    <span class="text-sm font-medium text-blue-600 dark:text-blue-400">
                                        {{ number_format($data['expected_q4'], 2) }}
                                    </span>
                                </div>
                                <div class="flex justify-between items-center">
                                    <span
                                        class="text-xs text-gray-600 dark:text-gray-300">{{ __('initiative_result.actual') }}:</span>
                                    <span class="text-sm font-medium text-green-600 dark:text-green-400">
                                        {{ number_format($data['actual_q4'], 2) }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @endif

    {{-- No Results Message --}}
    @if(empty($resultsByPerformanceCardResult) && ($aggregatedData['expected_q1'] == 0 && $aggregatedData['expected_q2'] == 0 && $aggregatedData['expected_q3'] == 0 && $aggregatedData['expected_q4'] == 0))
        <div class="text-gray-500 text-center py-8">
            <svg class="w-12 h-12 mx-auto mb-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z">
                </path>
            </svg>
            <p class="text-sm">{{ __('performance_card.no_initiative_results_yet') }}</p>
        </div>
    @endif
</div>