@php
    $orderStatuses = \App\Models\Order::getOrderStatuses();
@endphp

<div class="rounded-xl p-4 bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700">
    <div class="flex flex-wrap gap-x-1 items-center gap-y-2">

        {{-- show created info --}}
        <div class="flex-1 flex flex-col items-center min-w-[120px]">
            <!-- Status Label -->
            <span class="text-xs font-semibold mb-2 px-3 text-center truncate w-full text-gray-600 dark:text-gray-300">
                {{ __(\App\Models\Order::getOrderStatuses()[\App\Models\Order::STATUS_CREATED]) }}
            </span>

            <!-- Progress Bar -->
            <div class="w-full mb-1">
                <div class="h-1.5 w-full rounded-full" style="background-color: #10b981;"></div>
            </div>

            <!-- Date and User Info -->
            <div class="flex flex-col items-center space-y-1">
                <span class="text-xs font-semibold text-gray-700 dark:text-gray-300">
                    {{ $getRecord()->created_at->format('d-m-Y') }}
                </span>
                <span class="text-xs font-semibold text-gray-700 dark:text-gray-300">
                    {{ $getRecord()->user->name }}
                </span>
            </div>
        </div>

        {{-- Loop through each order status except STATUS_CREATED, STATUS_REJECTED and STATUS_ACCEPTED
        --}}
        @php
            $afterCurrent = false;
        @endphp
        @foreach($orderStatuses as $orderStatus => $orderStatusText)
            {{-- continue if STATUS_CREATED or STATUS_REJECTED or STATUS_ACCEPTED --}}
            @continue($orderStatus === \App\Models\Order::STATUS_CREATED || $orderStatus === \App\Models\Order::STATUS_REJECTED || $orderStatus === \App\Models\Order::STATUS_ACCEPTED)

            @php
                $isCompleted = $getRecord()->isStatusCompleted($orderStatus);
                $activity = $getRecord()->getActivityForStatus($orderStatus);
                $isCurrent = $getRecord()->status === $orderStatus;
                if ($isCurrent) {
                    $afterCurrent = true;
                }
            @endphp

            <div class="flex-1 flex flex-col items-center min-w-[120px]">
                <!-- Status Label -->
                <span
                    class="text-xs font-semibold mb-2 px-3 text-center truncate w-full {{ $isCurrent ? 'text-primary-600 dark:text-primary-400' : 'text-gray-600 dark:text-gray-300' }}">
                    {{ __($orderStatusText) }}
                </span>

                <!-- Progress Bar -->
                <div class="w-full mb-1">
                    @if($afterCurrent && !$isCurrent)
                        <div class="h-1.5 w-full rounded-full bg-gray-100 dark:bg-gray-700"></div>
                    @elseif($isCompleted && !$isCurrent)
                        <div class="h-1.5 w-full rounded-full" style="background-color: #10b981;"></div>
                    @else
                        <div class="h-1.5 w-full rounded-full bg-gray-200 dark:bg-gray-600"></div>
                    @endif
                </div>

                <!-- Date and User Info -->
                <div class="flex flex-col items-center space-y-1">
                    @if($afterCurrent || $isCurrent)
                        <span class="text-xs font-semibold text-gray-400 dark:text-gray-500">{{ '-' }}</span>
                        <span class="text-xs font-semibold text-gray-400 dark:text-gray-500">{{ '-' }}</span>
                    @else
                        <span
                            class="text-xs font-semibold {{ $isCompleted ? 'text-gray-700 dark:text-gray-300' : 'text-gray-400 dark:text-gray-500' }}">
                            {{ $activity?->created_at ? $activity->created_at->format('d-m-Y') : '-' }}
                        </span>
                        <span
                            class="text-xs font-semibold {{ $isCompleted ? 'text-gray-700 dark:text-gray-300' : 'text-gray-400 dark:text-gray-500' }}">
                            {{ $activity?->causer?->name ?? '-' }}
                        </span>
                    @endif
                </div>
            </div>
        @endforeach

    </div>
</div>