@php
    use App\Enums\LicenseStatus;
@endphp

<div class="rounded-xl p-4 bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700">
    <div class="flex flex-wrap gap-x-1 items-center gap-y-2">

        {{-- Show created info --}}
        <div class="flex-1 flex flex-col items-center min-w-[120px]">
            <!-- Status Label -->
            <span class="text-xs font-semibold mb-2 px-3 text-center truncate w-full text-gray-600 dark:text-gray-300">
                {{ LicenseStatus::CREATED->getLabel() }}
            </span>

            <!-- Progress Bar -->
            <div class="w-full mb-1">
                <div class="h-1.5 w-full rounded-full" style="background-color: #10b981;"></div>
            </div>

            <!-- Date and User Info -->
            <div class="flex flex-col items-center space-y-1">
                <span class="text-xs font-semibold text-gray-700 dark:text-gray-300">
                    {{ $getRecord()->created_at->format('d-m-Y') }}
                </span>
                <span class="text-xs font-semibold text-gray-700 dark:text-gray-300">
                    {{ $getRecord()->createdBy?->name ?? '—' }}
                </span>
            </div>
        </div>

        {{-- Loop through approval statuses (PENDING_REQUIREMENTS, INITIAL_APPROVAL, FINAL_APPROVAL, APPROVED) --}}
        @php
            $afterCurrent = false;
            $approvalStatuses = [
                LicenseStatus::PENDING_REQUIREMENTS,
                LicenseStatus::INITIAL_APPROVAL,
                LicenseStatus::FINAL_APPROVAL,
            ];
        @endphp

        @foreach($approvalStatuses as $status)
            @php
                $isCompleted = $getRecord()->isStatusCompleted($status->value);
                $activity = $getRecord()->getActivityForStatus($status->value);
                $isCurrent = $getRecord()->status === $status;
                if ($isCurrent) {
                    $afterCurrent = true;
                }
            @endphp

            <div class="flex-1 flex flex-col items-center min-w-[120px]">
                <!-- Status Label -->
                <span
                    class="text-xs font-semibold mb-2 px-3 text-center truncate w-full {{ $isCurrent ? 'text-primary-600 dark:text-primary-400' : 'text-gray-600 dark:text-gray-300' }}">
                    {{ $status->getLabel() }}
                </span>

                <!-- Progress Bar -->
                <div class="w-full mb-1">
                    @if($afterCurrent && !$isCurrent)
                        <div class="h-1.5 w-full rounded-full bg-gray-100 dark:bg-gray-700"></div>
                    @elseif($isCompleted && !$isCurrent)
                        <div class="h-1.5 w-full rounded-full" style="background-color: #10b981;"></div>
                    @else
                        <div class="h-1.5 w-full rounded-full bg-gray-200 dark:bg-gray-600"></div>
                    @endif
                </div>

                <!-- Date and User Info -->
                <div class="flex flex-col items-center space-y-1">
                    @if($afterCurrent || $isCurrent)
                        <span class="text-xs font-semibold text-gray-400 dark:text-gray-500">{{ '—' }}</span>
                        <span class="text-xs font-semibold text-gray-400 dark:text-gray-500">{{ '—' }}</span>
                    @else
                        <span
                            class="text-xs font-semibold {{ $isCompleted ? 'text-gray-700 dark:text-gray-300' : 'text-gray-400 dark:text-gray-500' }}">
                            {{ $activity?->created_at ? $activity->created_at->format('d-m-Y') : '—' }}
                        </span>
                        <span
                            class="text-xs font-semibold {{ $isCompleted ? 'text-gray-700 dark:text-gray-300' : 'text-gray-400 dark:text-gray-500' }}">
                            {{ $activity?->causer?->name ?? '—' }}
                        </span>
                    @endif
                </div>
            </div>
        @endforeach

        {{-- Show rejected status if applicable --}}
        @if($getRecord()->status === LicenseStatus::REJECTED)
            <div class="flex-1 flex flex-col items-center min-w-[120px]">
                <!-- Status Label -->
                <span class="text-xs font-semibold mb-2 px-3 text-center truncate w-full text-danger-600 dark:text-danger-400">
                    {{ LicenseStatus::REJECTED->getLabel() }}
                </span>

                <!-- Progress Bar -->
                <div class="w-full mb-1">
                    <div class="h-1.5 w-full rounded-full" style="background-color: #ef4444;"></div>
                </div>

                <!-- Date and User Info -->
                <div class="flex flex-col items-center space-y-1">
                    @php
                        $rejectedActivity = $getRecord()->getActivityForStatus(LicenseStatus::REJECTED->value);
                    @endphp
                    <span class="text-xs font-semibold text-danger-700 dark:text-danger-300">
                        {{ $rejectedActivity?->created_at ? $rejectedActivity->created_at->format('d-m-Y') : '—' }}
                    </span>
                    <span class="text-xs font-semibold text-danger-700 dark:text-danger-300">
                        {{ $rejectedActivity?->causer?->name ?? '—' }}
                    </span>
                </div>
            </div>
        @endif

    </div>
</div>
