@php
    $exchangeRequestStatuses = \App\Models\ExchangeRequest::getStatuses();
@endphp

<div class="rounded-xl p-4 bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700">
    <div class="flex flex-wrap gap-x-1 items-center gap-y-2">

        {{-- Show created info --}}
        <div class="flex-1 flex flex-col items-center min-w-[120px]">
            <!-- Status Label -->
            <span class="text-xs font-semibold mb-2 px-3 text-center truncate w-full text-gray-600 dark:text-gray-300">
                {{ __('exchange_request.status_draft') }}
            </span>

            <!-- Progress Bar -->
            <div class="w-full mb-1">
                <div class="h-1.5 w-full rounded-full" style="background-color: #10b981;"></div>
            </div>

            <!-- Date Info -->
            <div class="flex flex-col items-center space-y-1">
                <span class="text-xs font-semibold text-gray-700 dark:text-gray-300">
                    {{ $getRecord()->created_at->format('d-m-Y') }}
                </span>
                <span class="text-xs font-semibold text-gray-700 dark:text-gray-300">
                    {{ $getRecord()->createdBy?->name ?? '-' }}
                </span>
            </div>
        </div>

        {{-- Loop through each exchange request status except STATUS_DRAFT, STATUS_REJECTED and STATUS_APPROVED --}}
        @foreach($exchangeRequestStatuses as $status => $statusText)
            {{-- Continue if STATUS_DRAFT or STATUS_REJECTED or STATUS_APPROVED --}}
            @continue($status === \App\Models\ExchangeRequest::STATUS_DRAFT || $status === \App\Models\ExchangeRequest::STATUS_REJECTED || $status === \App\Models\ExchangeRequest::STATUS_APPROVED)

            @php
                $isCompleted = $getRecord()->isStatusCompleted($status);
                $activity = $getRecord()->getActivityForStatus($status);
                $isCurrent = $getRecord()->status === $status;
            @endphp

            <div class="flex-1 flex flex-col items-center min-w-[120px]">
                <!-- Status Label -->
                <span
                    class="text-xs font-semibold mb-2 px-3 text-center truncate w-full {{ $isCurrent ? 'text-primary-600 dark:text-primary-400' : 'text-gray-600 dark:text-gray-300' }}">
                    {{ __("exchange_request.status_{$status}") }}
                </span>

                <!-- Progress Bar -->
                <div class="w-full mb-1">
                    @if($isCompleted)
                        <div class="h-1.5 w-full rounded-full" style="background-color: #10b981;"></div>
                    @elseif($isCurrent)
                        <div class="h-1.5 w-full bg-gray-200 dark:bg-gray-600 rounded-full">
                            <div class="h-1.5 bg-gradient-to-r from-primary-500 to-primary-600 rounded-full animate-pulse"
                                style="width: 50%;"></div>
                        </div>
                    @else
                        <div class="h-1.5 w-full bg-gray-200 dark:bg-gray-600 rounded-full"></div>
                    @endif
                </div>

                <!-- Date and User Info -->
                @if($isCurrent)
                    <div class="flex flex-col items-center space-y-1">
                        <span class="text-xs font-medium text-primary-600 dark:text-primary-400">
                            {{ __('exchange_request.pending') }}
                        </span>
                        <span class="text-xs font-semibold text-gray-400 dark:text-gray-500">
                            {{ '-' }}
                        </span>
                    </div>
                @elseif($isCompleted && $activity)
                    <div class="flex flex-col items-center space-y-1">
                        <span class="text-xs font-semibold text-gray-700 dark:text-gray-300">
                            {{ $activity->created_at->format('d-m-Y') }}
                        </span>
                        @if($activity->causer)
                            <span class="text-xs font-semibold text-gray-700 dark:text-gray-300">
                                {{ $activity->causer->name }}
                            </span>
                        @endif
                    </div>
                @else
                    <div class="flex flex-col items-center space-y-1">
                        <span class="text-xs font-semibold text-gray-700 dark:text-gray-300">
                            {{ '-' }}
                        </span>
                        <span class="text-xs font-semibold text-gray-700 dark:text-gray-300">
                            {{ '-' }}
                        </span>
                    </div>
                @endif
            </div>
        @endforeach
    </div>
</div>