@php
    $association = auth()->user()->association;
@endphp

<x-filament-widgets::widget>
    <x-filament::section>
        <div class="flex items-center gap-4">
            <div class="relative">
                <x-filament::avatar src="{{ $association->logo_url ?? '' }}" alt="{{ $association->name . ' Logo' }}"
                    class="!w-20 !h-20 border" />

                {{-- <x-filament::button color="primary"
                    class="!rounded-full !p-1 !absolute !bottom-0 !right-0 !w-7 !h-7">
                    @if ($association->hasMedia('logo'))
                    <x-filament::icon icon="heroicon-o-pencil" class="w-4 h-4 text-white" />
                    @else
                    <x-filament::icon icon="heroicon-o-plus" class="w-5 h-5 text-white" />
                    @endif
                </x-filament::button> --}}
            </div>

            <div class="flex flex-col gap-3">
                <p class="text-2xl font-bold">{{ $association->name }}</p>

                <div class="flex gap-6">
                    <p class="text-zinc-600 font-semibold dark:text-zinc-400">
                        {{ $association->representative_full_name }}
                    </p>
                    <hr class="border-l border-zinc-300 h-6" />
                    <p class="text-blue-500 font-semibold">{{ $association->representative_position }}</p>
                </div>
            </div>
        </div>

        <div
            class="flex items-center justify-between bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4 text-sm text-zinc-600 mt-8">

            <div class="flex-1 text-center border-e border-zinc-200 px-2 flex flex-col gap-2">
                <p class="text-sm text-zinc-400">{{ __('association-file.contact_info_labels.phone_number') }}</p>
                <div class="font-semibold text-lg text-zinc-900 dark:text-zinc-200">
                    {{ $association->phone_number }}
                </div>
            </div>

            <div class="flex-1 text-center px-2 flex flex-col gap-2">
                <p class="text-sm text-zinc-400">{{ __('association-file.contact_info_labels.email') }}</p>
                <div class="font-semibold text-lg text-zinc-900 dark:text-zinc-200">
                    {{ $association->email }}
                </div>
            </div>

        </div>
    </x-filament::section>
</x-filament-widgets::widget>