<x-filament-widgets::widget>
    <x-filament::section>
        <h2 class="text-zinc-400 font-bold">
            {{ __('association-admin-dashboard.registration_progress.title') }}
        </h2>

        <div class="mb-2 mt-4 flex justify-end">
            <span class="text-sm text-gray-600">
                {{ __('association-admin-dashboard.registration_progress.progress', ['percentage' => $percentage]) }}
            </span>
        </div>

        <div class="w-full bg-gray-200 h-2 rounded overflow-hidden">
            <div class="h-2 bg-green-500" style="width: {{ $percentage }}%;"></div>
        </div>

        <hr class="my-4" />

        <ul class="space-y-3">
            @foreach ($steps as $step)
                <li class="flex items-center">
                    @if ($step['completed'])
                        <x-heroicon-m-check-circle class="w-8 h-8 text-green-500" />
                        <span class="ms-3 text-gray-500 font-bold">
                            {{ __('association-admin-dashboard.registration_steps.' . $step['id']) }}
                        </span>
                    @else
                        <x-heroicon-s-check-circle class="w-8 h-8 text-zinc-300" />
                        <span class="ms-3 text-gray-500">
                            {{ __('association-admin-dashboard.registration_steps.' . $step['id']) }}
                        </span>
                    @endif
                </li>
            @endforeach
        </ul>

    </x-filament::section>
</x-filament-widgets::widget>
