<x-filament-widgets::widget>
    <x-filament::section>
        <form wire:submit.prevent="submit">
            {{ $this->form }}

            <x-filament::button type="submit" color="primary" class="mt-4 w-full">
                حفظ
            </x-filament::button>
        </form>
    </x-filament::section>

    {{-- Reuse existing OTP modal --}}
    <livewire:otp-form-modal />

    {{-- Confirmation Modal for Unsaved Changes --}}
    <x-filament::modal id="confirm-discard-changes" width="md">
        <x-slot name="heading">
            <div class="flex items-center gap-3">
                <div class="flex items-center justify-center w-12 h-12 rounded-full bg-warning-100 dark:bg-warning-500/20">
                    <x-heroicon-o-exclamation-triangle class="w-6 h-6 text-warning-600 dark:text-warning-400" />
                </div>
                <span class="text-xl font-semibold">
                    {{ __('association.unsaved_changes_title') }}
                </span>
            </div>
        </x-slot>

        <div class="space-y-4">
            <p class="text-gray-600 dark:text-gray-400">
                {{ __('association.unsaved_changes_message') }}
            </p>
        </div>

        <x-slot name="footerActions">
            <x-filament::button color="gray" wire:click="cancelDiscardChanges">
                {{ __('association.cancel') }}
            </x-filament::button>

            <x-filament::button color="danger" wire:click="confirmDiscardChanges">
                {{ __('association.discard_changes') }}
            </x-filament::button>
        </x-slot>
    </x-filament::modal>
</x-filament-widgets::widget>
