<x-filament-widgets::widget>
    <x-filament::section>
        <div class="space-y-1">
            @foreach ($this->items()[0] as $item)
                <x-filament::button @class([
                    '!justify-start items-center gap-2 px-4 py-2 text-sm font-semibold transition rounded-lg !shadow-none hover:!bg-zinc-100 w-full dark:hover:!bg-zinc-800',
                    '!bg-zinc-100 !text-primary-500 [&>svg]:text-primary-500 dark:!bg-zinc-800' =>
                        $item['id'] === $this->currentSection,
                    '!bg-transparent text-zinc-700 dark:text-zinc-200 [&>svg]:text-zinc-700 dark:[&>svg]:text-zinc-200' =>
                        $item['id'] !== $this->currentSection,
                ]) icon="{{ $item['icon'] }}"
                    wire:click="setCurrentSection('{{ $item['id'] }}')">
                    {{ $item['label'] }}
                </x-filament::button>
            @endforeach
        </div>
    </x-filament::section>

    <x-filament::section class="mt-4">
        <div class="space-y-1">
            @foreach ($this->items()[1] as $item)
                <x-filament::button @class([
                    '!justify-start items-center gap-2 px-4 py-2 text-sm font-semibold transition rounded-lg !shadow-none hover:!bg-zinc-100 w-full dark:hover:!bg-zinc-800',
                    '!bg-zinc-100 !text-primary-500 [&>svg]:text-primary-500 dark:!bg-zinc-800' =>
                        $item['id'] === $this->currentSection,
                    '!bg-transparent text-zinc-700 dark:text-zinc-200 [&>svg]:text-zinc-700 dark:[&>svg]:text-zinc-200' =>
                        $item['id'] !== $this->currentSection,
                ]) icon="{{ $item['icon'] }}"
                    wire:click="setCurrentSection('{{ $item['id'] }}')">
                    {{ $item['label'] }}
                </x-filament::button>
            @endforeach
        </div>
    </x-filament::section>
</x-filament-widgets::widget>
