<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>الموقع تحت الصيانة</title>
    
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            margin: 0;
            padding: 0;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #333;
        }
        
        .maintenance-container {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            padding: 60px 40px;
            text-align: center;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
            backdrop-filter: blur(10px);
            max-width: 600px;
            width: 90%;
            margin: 20px;
        }
        
        .logo {
            max-width: 200px;
            height: auto;
            margin-bottom: 40px;
            filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.1));
        }
        
        .maintenance-title {
            font-size: 2.5rem;
            font-weight: bold;
            color: #1A4792;
            margin-bottom: 30px;
            line-height: 1.2;
        }
        
        .maintenance-message {
            font-size: 1.2rem;
            color: #666;
            margin-bottom: 40px;
            line-height: 1.6;
        }
        
        .maintenance-icon {
            font-size: 4rem;
            color: #1A4792;
            margin-bottom: 30px;
            opacity: 0.8;
        }
        
        .back-soon {
            font-size: 1rem;
            color: #888;
            font-style: italic;
        }
        
        @media (max-width: 768px) {
            .maintenance-container {
                padding: 40px 30px;
            }
            
            .maintenance-title {
                font-size: 2rem;
            }
            
            .logo {
                max-width: 150px;
            }
            
            .maintenance-icon {
                font-size: 3rem;
            }
        }
    </style>
</head>

<body>
    <div class="maintenance-container">
        <!-- Brand Logo -->
        <div>
            <img src="{{ Vite::asset('resources/images/sekaya-association-admin-brand-logo.svg') }}" 
                 alt="Sekaya Association Logo" 
                 class="logo">
        </div>
        
        <!-- Maintenance Icon -->
        <div class="maintenance-icon">
            🔧
        </div>
        
        <!-- Main Message in Arabic -->
        <h1 class="maintenance-title">
            الموقع تحت الصيانة
        </h1>
        
        <!-- Additional Message -->
        <p class="maintenance-message">
            نعمل حالياً على تحسين الموقع لتقديم خدمة أفضل لكم
        </p>
        
        <!-- Back Soon Message -->
        <p class="back-soon">
            سنعود قريباً...
        </p>
    </div>
</body>

</html>