<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ app()->getLocale() === 'ar' ? 'rtl' : 'ltr' }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ __('common.access_denied') }}</title>

    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            margin: 0;
            padding: 0;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #333;
        }

        .error-container {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            padding: 60px 40px;
            text-align: center;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
            backdrop-filter: blur(10px);
            max-width: 600px;
            width: 90%;
            margin: 20px;
        }

        .logo {
            max-width: 200px;
            height: auto;
            margin-bottom: 40px;
            filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.1));
        }

        .error-code {
            font-size: 8rem;
            font-weight: bold;
            color: #dc3545;
            margin-bottom: 20px;
            line-height: 1;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.1);
        }

        .error-title {
            font-size: 2.5rem;
            font-weight: bold;
            color: #1A4792;
            margin-bottom: 30px;
            line-height: 1.2;
        }

        .error-message {
            font-size: 1.2rem;
            color: #666;
            margin-bottom: 40px;
            line-height: 1.6;
        }

        .actions {
            display: flex;
            gap: 20px;
            justify-content: center;
            flex-wrap: wrap;
            margin-top: 30px;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 15px 30px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            font-size: 1rem;
            transition: all 0.3s ease;
            border: none;
            cursor: pointer;
            min-width: 160px;
            gap: 10px;
        }

        .btn-primary {
            background: linear-gradient(45deg, #1A4792, #2563eb);
            color: white;
            box-shadow: 0 4px 15px rgba(37, 99, 235, 0.4);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(37, 99, 235, 0.6);
        }

        .btn-secondary {
            background: linear-gradient(45deg, #6b7280, #9ca3af);
            color: white;
            box-shadow: 0 4px 15px rgba(107, 114, 128, 0.4);
        }

        .btn-secondary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(107, 114, 128, 0.6);
        }

        .btn-warning {
            background: linear-gradient(45deg, #f59e0b, #fbbf24);
            color: white;
            box-shadow: 0 4px 15px rgba(245, 158, 11, 0.4);
        }

        .btn-warning:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(245, 158, 11, 0.6);
        }

        .icon {
            width: 20px;
            height: 20px;
            fill: currentColor;
        }

        .security-note {
            background: rgba(220, 53, 69, 0.1);
            border: 1px solid rgba(220, 53, 69, 0.2);
            border-radius: 10px;
            padding: 20px;
            margin: 30px 0;
            color: #721c24;
        }

        .security-note h4 {
            margin: 0 0 10px 0;
            font-weight: bold;
        }

        .security-note p {
            margin: 0;
            font-size: 0.95rem;
        }

        /* RTL Support */
        [dir="rtl"] .actions {
            direction: rtl;
        }

        [dir="rtl"] .btn {
            direction: ltr;
            /* Keep button content LTR for better icon alignment */
        }

        @media (max-width: 768px) {
            .error-container {
                padding: 40px 20px;
            }

            .error-code {
                font-size: 6rem;
            }

            .error-title {
                font-size: 2rem;
            }

            .error-message {
                font-size: 1rem;
            }

            .actions {
                flex-direction: column;
                align-items: center;
            }

            .btn {
                width: 100%;
                max-width: 300px;
            }
        }
    </style>
</head>

<body>
    <div class="error-container">
        {{-- Logo --}}
        @if(file_exists(public_path('images/logo.png')))
            <img src="{{ asset('images/logo.png') }}" alt="Logo" class="logo">
        @endif

        {{-- Error Code --}}
        <div class="error-code">403</div>

        {{-- Error Title --}}
        <h1 class="error-title">
            {{ __('common.access_denied') ?? 'Access Denied' }}
        </h1>

        {{-- Error Message --}}
        <div class="error-message">
            {{ __('common.access_denied_message') ?? 'You do not have permission to access this resource. Please contact your administrator if you believe this is an error.' }}
        </div>

        {{-- Security Note --}}
        <div class="security-note">
            <h4>{{ __('common.security_notice') ?? 'Security Notice' }}</h4>
            <p>{{ __('common.security_notice_message') ?? 'This action has been logged for security purposes.' }}</p>
        </div>

        {{-- Action Buttons --}}
        <div class="actions">
            {{-- Leave Impersonating Button (only show if impersonating) --}}
            @if(session()->has('impersonated_by'))
                <a href="{{ route('filament-impersonate.leave') }}" class="btn btn-warning">
                    <svg class="icon" viewBox="0 0 24 24">
                        <path
                            d="M16 17v-3H9v-4h7V7l5 5-5 5M14 2a2 2 0 012 2v2h-2V4H4v16h10v-2h2v2a2 2 0 01-2 2H4a2 2 0 01-2-2V4a2 2 0 012-2h10z" />
                    </svg>
                    {{ __('common.leave_impersonating') ?? 'Leave Impersonating' }}
                </a>
            @endif

            {{-- Logout Button --}}
            @auth
                @php
                    $logoutRoute = null;
                    $currentPanel = null;

                    // Detect current panel based on URL or context
                    if (request()->is('admin*')) {
                        $logoutRoute = 'filament.admin.auth.logout';
                        $currentPanel = 'admin';
                    } elseif (request()->is('association-admin*')) {
                        $logoutRoute = 'filament.association-admin.auth.logout';
                        $currentPanel = 'association-admin';
                    } else {
                        // Default to admin panel
                        $logoutRoute = 'filament.admin.auth.logout';
                        $currentPanel = 'admin';
                    }
                @endphp

                <form method="POST" action="{{ route($logoutRoute) }}" style="display: inline;">
                    @csrf
                    <button type="submit" class="btn btn-secondary">
                        <svg class="icon" viewBox="0 0 24 24">
                            <path
                                d="M16 17v-3H9v-4h7V7l5 5-5 5M14 2a2 2 0 012 2v2h-2V4H4v16h10v-2h2v2a2 2 0 01-2 2H4a2 2 0 01-2-2V4a2 2 0 012-2h10z" />
                        </svg>
                        {{ __('common.logout') ?? 'Logout' }}
                    </button>
                </form>
            @endauth

            {{-- Go Back Button --}}
            <button onclick="window.history.back()" class="btn btn-primary">
                <svg class="icon" viewBox="0 0 24 24">
                    <path d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z" />
                </svg>
                {{ __('common.go_back') ?? 'Go Back' }}
            </button>
        </div>
    </div>
</body>

</html>