<?php

return [
    // Model names
    'risk_register' => 'Risk Register',
    'risk_registers' => 'Risk Registers',

    // Navigation
    'manage_risk_registers' => 'Manage Risk Registers',

    // Fields
    'incident_likelihood' => 'Incident Likelihood',
    'impact_level' => 'Impact Level',
    'impact_on_cost' => 'Impact on Cost',
    'impact_on_time' => 'Impact on Time',
    'mitigation_plan' => 'Mitigation Plan',
    'contingency_plan' => 'Contingency Plan',
    'financial_contingency' => 'Financial Contingency',
    'technical_contingency' => 'Technical Contingency',

    // Form sections
    'risk_assessment' => 'Risk Assessment',
    'risk_assessment_description' => 'Assess the likelihood and potential impact of risks',
    'mitigation_strategies' => 'Mitigation Strategies',
    'mitigation_strategies_description' => 'Define plans to prevent and respond to risks',

    // Field options
    'likelihood_very_low' => 'Very Low',
    'likelihood_low' => 'Low',
    'likelihood_medium' => 'Medium',
    'likelihood_high' => 'High',
    'likelihood_very_high' => 'Very High',

    'impact_low' => 'Low',
    'impact_medium' => 'Medium',
    'impact_high' => 'High',

    'impact_negligible' => 'Negligible',
    'impact_minor' => 'Minor',
    'impact_moderate' => 'Moderate',
    'impact_major' => 'Major',
    'impact_critical' => 'Critical',

    'cost_impact_none' => 'No Impact',
    'cost_impact_minimal' => 'Minimal (<5%)',
    'cost_impact_moderate' => 'Moderate (5-15%)',
    'cost_impact_significant' => 'Significant (15-25%)',
    'cost_impact_severe' => 'Severe (>25%)',

    'time_impact_none' => 'No Delay',
    'time_impact_minimal' => 'Minimal Delay (<1 week)',
    'time_impact_moderate' => 'Moderate Delay (1-4 weeks)',
    'time_impact_significant' => 'Significant Delay (1-3 months)',
    'time_impact_severe' => 'Severe Delay (>3 months)',

    // Placeholders and helpers
    'incident_likelihood_placeholder' => 'Select the likelihood of this risk occurring',
    'impact_level_placeholder' => 'Select the overall impact level',
    'impact_on_cost_placeholder' => 'Select the potential impact on project cost',
    'impact_on_time_placeholder' => 'Select the potential impact on project timeline',
    'mitigation_plan_placeholder' => 'Describe the steps to prevent this risk from occurring',
    'contingency_plan_placeholder' => 'Describe the response plan if this risk occurs',
    'financial_contingency_placeholder' => 'Describe financial reserves or backup funding',
    'technical_contingency_placeholder' => 'Describe technical alternatives or backup solutions',

    // Messages
    'created_successfully' => 'Risk register entry created successfully',
    'updated_successfully' => 'Risk register entry updated successfully',
    'deleted_successfully' => 'Risk register entry deleted successfully',
    'no_risks_identified' => 'No risks have been identified for this project charter yet',

    // Validation
    'charter_required' => 'Project charter is required',
    'mitigation_plan_required' => 'Mitigation plan is required when impact level is major or critical',
    'contingency_plan_required' => 'Contingency plan is required when impact level is major or critical',

    // Table columns
    'risk_summary' => 'Risk Summary',
    'likelihood_impact' => 'Likelihood × Impact',
    'created_at' => 'Created',
    'updated_at' => 'Updated',
];
