<?php

return [
    // General
    'order' => 'Order',
    'orders' => 'Orders',
    'order_management' => 'Order Management',
    'all' => 'All Orders',
    'create_order' => 'Create Order',

    // Model attributes and sections
    'association' => 'Association',
    'order_name' => 'Order Name',
    'order_number' => 'Order Number',
    'order_type' => 'Order Type',
    'created_by' => 'Created By',
    'state' => 'State',
    'city' => 'City',
    'centers' => 'Centers',
    'coordinates' => 'Coordinates',
    'coordinates_placeholder' => 'e.g., 24.7136, 46.6753',
    'coordinates_helper' => 'Enter coordinates in format: latitude, longitude',
    'location' => 'Location',
    'residential_gatherings' => 'Residential Gatherings',
    'residential_gathering' => 'Residential Gathering',
    'residential_gatherings_helper' => 'Select specific residential gatherings from the chosen centers (auto-populated)',
    'no_residential_gatherings' => 'No residential gatherings linked',
    'rg_summary' => ':count gatherings, :population people, :families families',
    'total_population' => 'Total Population',
    'total_families' => 'Total Families',
    'center_total' => 'Center Total',
    'people' => 'people',
    'number_of_families' => 'Number of Families',
    'actual_families_count' => 'Actual Families Count',
    'families' => 'families',
    'number_of_families_helper' => 'This field is pre-filled based on selected centers but can be modified',
    'calculated_families_count' => 'Calculated Families Count (from Centers)',
    'families_count_from_centers' => 'Families Count from Centers',
    'manual_families_entry' => 'Manual Families Entry',
    'used_in_reports' => 'This value is used in reports and statistics',
    'manual_entry_by_association' => 'Manual entry by association (for reference only)',
    'water_source' => 'Water Source',
    'water_source_helper' => 'Select one or more water sources available in the area',
    'water_distance' => 'Water Distance (km)',
    'km_suffix' => 'km',
    'development_impacts' => 'Development Impacts',
    'order_justifications' => 'Order Justifications',
    'order_description' => 'Order Description',
    'order_description_helper' => 'This field is optional',
    'status' => 'Status',
    'files' => 'Files',
    'created_at' => 'Created At',
    'updated_at' => 'Updated At',

    // Sections
    'order_information' => 'Order Information',
    'location_information' => 'Location Information',
    'pre_registered_information' => 'Pre-registered System Information',
    'water_source_information' => 'Water Source Information',
    'project_details' => 'Project Details',
    'required_files' => 'Required Files',
    'order_files' => 'Order Files',

    // ViewOrder page sections
    'order_details' => 'Order Details',
    'association_information' => 'Association Information',
    'uploaded_files' => 'Uploaded Files',
    'financial_information' => 'Financial Information',
    'donor_financial_portfolios' => 'Donor Financial Portfolios',
    'agreement_information' => 'Agreement Information',
    'location_map' => 'Location Map',
    'nearest_water_sources' => 'Nearest Water Sources',
    'requirements' => 'Requirements',
    'no_description' => 'No description provided',
    'no_requirements' => 'No requirements found',
    'portfolio_allocations' => 'Portfolio Allocations',
    'no_portfolio_allocations' => 'No portfolio allocations found',
    'sar' => 'SAR',
    'no_files_uploaded' => 'No files uploaded',
    'no_address' => 'No address provided',
    'association_name' => 'Association Name',
    'association_email' => 'Association Email',
    'association_phone' => 'Association Phone',
    'association_registration_number' => 'Registration Number',
    'association_address' => 'Association Address',
    'current_status_notes' => 'Current Status Notes',

    // File requirements
    // Messages and actions
    'select_type_first' => 'Please select an order type first to see required files.',
    'no_files_required' => 'No files are required for this order type.',
    'file_guidance_available' => 'Guidance document available:',
    'download_guidance' => 'Download Guidance',
    'station_guide_file_helper' => 'Download the requirements and specifications document',

    // File requirements
    'station_location' => 'Station Location',
    'station_license' => 'Station License',
    'tanker_specs' => 'Tanker Specs',

    // Types
    'station' => 'Station',
    'tanker' => 'Tanker',
    'domestic_storage_tank' => 'Domestic Storage Tanks',
    'central_storage_tank' => 'Central Storage Tanks',
    'maintenance_station' => 'Maintenance Stations',
    'maintenance_tanker' => 'Maintenance Tankers',
    'micro_network' => 'Micro Networks',
    'other' => 'Other',
    'well_drilling' => 'Well Drilling',
    'rainwater_storage' => 'Rainwater Storage',
    'home_filters' => 'Home Filters',
    'water_bottles' => 'Water Bottles',
    'coolers' => 'Coolers',
    'products_under_review' => 'Products Under Review',
    'well_purification_licenses' => 'Licenses for Wells and Purification Stations',

    // Water Sources
    'government' => 'Government',
    'private' => 'Private',
    'charity' => 'Charity',

    // Statuses
    'created' => 'Order Created',
    'pending_recommendation' => 'Pending Recommendation',
    'recommended' => 'Recommended',
    'technical_financial_requested' => 'Technical/Financial Proposal Requested',
    'technical_financial_approved' => 'Technical/Financial Proposal Approved',
    'project_manager_approved' => 'Project Manager Approved',
    'classification' => 'Classification',
    'agreement' => 'Agreement',
    'ceo_approved' => 'CEO Approved',
    'launched' => 'Launched',
    'accepted' => 'Accepted',
    'rejected' => 'Rejected',

    // Actions & Notifications
    'approve' => 'Approve',
    'reject' => 'Reject',
    'send_back' => 'Send Back',
    'send_back_confirmation' => 'Send Order Back',
    'send_back_description' => 'Are you sure you want to send this order back to the previous stage? This action will delete any records created during the current stage.',
    'send_back_notes' => 'Reason for sending back',
    'send_back_notes_helper' => 'Please provide a clear reason for sending the order back to the previous stage',
    'order_sent_back_successfully' => 'Order has been successfully sent back to the previous stage',
    'send_back_failed' => 'Failed to send order back to previous stage',
    'bulk_approve' => 'Bulk Approve',
    'bulk_approve_confirmation' => 'Bulk Approve Orders',
    'bulk_approve_description' => 'Are you sure you want to approve/recommend the selected orders?',
    'bulk_approve_success' => ':count order(s) approved successfully',
    'bulk_approve_partial_success' => ':success order(s) approved successfully, :failure order(s) failed',
    'bulk_approve_failed' => 'Failed to approve orders.',
    'bulk_approve_pending_requirements' => ':count order(s) have pending requirements that need to be resolved.',
    'bulk_approve_failed_pending_requirements' => 'Failed to approve orders. :count order(s) have pending requirements that need to be resolved first.',
    'approval_notes' => 'Approval Notes',
    'approval_notes_section' => 'Approval Notes',
    'rejection_notes' => 'Rejection Notes',
    'order_approved_successfully' => 'Order approved successfully',
    'approved_successfully' => 'Order approved successfully',
    'approval_failed' => 'Order approval failed',
    'order_rejected' => 'Order rejected',
    'timeline' => 'Timeline',
    'order_created_by' => 'Created by :name',
    'order_approved_by' => 'Order approved by :name.',
    'status_changed' => 'Status changed from <strong>:old_status</strong> to <strong>:new_status</strong>.',
    'order_rejected_by' => 'Order rejected by :name.',
    'status_was' => 'Status was <strong>:status</strong>.',
    'order_sent_back_by' => 'Order sent back by :name.',
    'notes' => 'Notes: :notes',
    'notes_na' => 'Notes: N/A',
    'order_requirements_pending' => 'Cannot approve order: There are pending requirements.',
    'recommend' => 'Recommend',
    'recommendation' => 'Recommendation',
    'no_timeline_activities' => 'No timeline activities',
    'no_timeline_activities_description' => 'No activities have been recorded for this order yet.',

    // Activity translations for exports
    'latest_activity_event' => 'Latest Activity',
    'latest_activity_user' => 'User',
    'latest_activity_date' => 'Activity Date',
    'activity_approved' => 'Approved',
    'activity_rejected' => 'Rejected',
    'activity_send_back' => 'Sent Back',

    // Finance validation

    // Finance validation
    'finance_not_created' => 'Finance information has not been created yet',
    'finance_approved_price' => 'Finance Approved Price',
    'finance_count' => 'Count',
    'finance_capacity' => 'Capacity',
    'finance_execution_duration' => 'Execution Duration (Months)',
    'finance_company_name' => 'Executing Company Name',
    'finance_offer_price' => 'Offer Price',
    'finance_additional_fees' => 'Additional Fees',
    'finance_operation_cost_percentage' => 'Operation Cost Percentage',
    'finance_expected_operation_cost' => 'Expected Operation Cost',
    'association_license_number' => 'Association License Number',
    'field_required' => 'The :field field is required',
    'cannot_approve_incomplete_finance' => 'Cannot approve order: Please complete all finance information before proceeding.',
    'approved_order_requirement' => 'Approved Order Requirement',

    // stats widget
    'stats' => [
        'total_orders' => 'Total Orders',
        'total_orders_description' => 'Total number of orders placed',
        'pending_orders' => 'Pending Orders',
        'pending_orders_description' => 'Number of orders currently pending',
        'launched_orders' => 'Launched Orders',
        'launched_orders_description' => 'Number of orders successfully launched',
        'accepted_orders' => 'Accepted Orders',
        'accepted_orders_description' => 'Number of orders that have been accepted',
    ],

    // File requirements for different order types
    'file_requirements' => [
        'acceptance_criteria_for_micro_treatment_plant' => 'Acceptance criteria for micro treatment plant',
        'ownership_or_lease_agreement' => 'Ownership deed, concession, or lease agreement from the well and land owner in favor of the association',
        'well_disclosure' => 'Well disclosure',
        'water_sample_analysis' => 'Well water sample analysis from an accredited laboratory',
        'project_land_buildings_plan' => 'Survey sketch showing the coordinates of the land corners and well coordinates from an accredited engineering office',
        'groundwater_usage_license' => 'Groundwater usage license from Nama platform (if available)',
        'commercial_registration' => 'Commercial registration',
        'home_tank_capacity' => 'Number and capacity of home tanks (maximum 8 fields)',
        'central_tank_capacity' => 'Number and capacity of central tanks',
        'station_technical_contract' => 'Station technical contract',
        'produced_water_analysis' => 'Produced water sample analysis from an accredited laboratory',
        'operational_report' => 'Operational report',
        'tanker_driver_contract' => 'Tanker driver contract',
        'vehicle_registration' => 'Valid vehicle registration',
        'vehicle_insurance' => 'Valid vehicle insurance',
        'well_and_tank_land_concession' => 'Concession from the owner for the well and surrounding land for tanks',
        'well_water_analysis' => 'Well water sample analysis from an accredited laboratory',
        'network_location_map' => 'Sketch showing the location of the well, tanks, and beneficiary houses',
        'project_feasibility_study' => 'Project feasibility study',
        'well_purification_license_form' => 'Well and Purification Stations License Application Form',
    ],

    // Export notifications
    'export_completed' => 'Your order export has completed and :count :rows exported.',
    'export_failed_rows' => ' :count :rows failed to export.',
    'row' => 'row',
    'rows' => 'rows',
];
