<?php

return [
    // Model names
    'exchange_request' => 'Exchange Request',
    'exchange_requests' => 'Exchange Requests',

    // Navigation
    'manage_exchange_requests' => 'Manage Exchange Requests',

    // Fields
    'id' => 'ID',
    'status' => 'Status',
    'completion_report' => 'Completion Report',
    'transaction_file' => 'Transaction File',
    'transaction_files' => 'Transaction Files',
    'files' => 'Files',
    'additional_files' => 'Additional Files',
    'transaction_date' => 'Transaction Date',
    'created_by' => 'Created By',
    'created_at' => 'Created At',
    'updated_at' => 'Updated At',

    // Status options
    'status_draft' => 'Draft',
    'status_created' => 'Created',
    'status_financial_approved' => 'Financial Approved',
    'status_shared_services_approved' => 'Shared Services Approved',
    'status_ceo_approved' => 'CEO Approved',
    'status_transaction_approved' => 'Transaction Approved',
    'status_approved' => 'Approved',
    'status_rejected' => 'Rejected',

    // Form sections
    'request_details' => 'Request Details',
    'request_details_description' => 'Provide details about the exchange request',
    'approval_workflow' => 'Approval Workflow',
    'approval_workflow_description' => 'Track the approval process for this exchange request',

    // Actions
    'create_exchange_request' => 'Create Exchange Request',
    'edit_exchange_request' => 'Edit Exchange Request',
    'view_exchange_request' => 'View Exchange Request',
    'delete_exchange_request' => 'Delete Exchange Request',
    'approve' => 'Approve',
    'reject' => 'Reject',
    'approve_to_next_stage' => 'Approve to Next Stage',
    'send_back' => 'Send Back',

    // Messages
    'created_successfully' => 'Exchange request created successfully',
    'updated_successfully' => 'Exchange request updated successfully',
    'deleted_successfully' => 'Exchange request deleted successfully',
    'approved_successfully' => 'Exchange request approved successfully',
    'rejected_successfully' => 'Exchange request rejected successfully',
    'exchange_request_sent_back_successfully' => 'Exchange request sent back successfully',
    'send_back_failed' => 'Failed to send back exchange request',

    // Help text
    'transaction_file_helper' => 'Upload the transaction file for this exchange request (Max: 10MB)',
    'transaction_files_helper' => 'Upload transaction files for this exchange request (Max: 10MB per file, up to 5 files)',
    'transaction_files_description' => 'Upload supporting transaction documents',
    'files_helper' => 'Upload additional files for this exchange request (Max: 10MB per file, up to 5 files)',
    'additional_files_description' => 'Upload additional supporting documents',
    'transaction_date_helper' => 'Date when the transaction was executed',
    'transaction_date_placeholder' => 'Select transaction date',

    // Validation
    'completion_report_required' => 'Completion report is required',

    // Empty states
    'no_exchange_requests' => 'No exchange requests found',
    'no_exchange_requests_description' => 'Create your first exchange request to get started',

    // Workflow
    'financial_approval' => 'Financial Approval',
    'shared_services_approval' => 'Shared Services Approval',
    'ceo_approval' => 'CEO Approval',
    'final_approval' => 'Final Approval',

    // Additional fields
    'approval_notes' => 'Approval Notes',
    'approval_notes_placeholder' => 'Optional notes about the approval...',
    'rejection_notes' => 'Rejection Notes',
    'rejection_notes_placeholder' => 'Please provide reason for rejection...',
    'send_back_notes' => 'Send Back Notes',
    'send_back_notes_helper' => 'Please provide reason for sending back this exchange request',

    // Confirmation messages
    'approve_confirm_title' => 'Approve Exchange Request',
    'approve_confirm_description' => 'Are you sure you want to approve this exchange request to the next stage?',
    'reject_confirm_title' => 'Reject Exchange Request',
    'reject_confirm_description' => 'Are you sure you want to reject this exchange request? This action cannot be undone.',
    'send_back_confirmation' => 'Send Back Exchange Request',
    'send_back_description' => 'Are you sure you want to send this exchange request back to the previous stage?',

    // Timeline and activity
    'timeline' => 'Timeline',
    'exchange_request_approved_by' => 'Exchange request approved by :name',
    'exchange_request_rejected_by' => 'Exchange request rejected by :name',
    'status_changed' => 'Status changed from :old_status to :new_status',
    'status_was' => 'Status was :status',
    'notes' => 'Notes: :notes',
    'notes_na' => 'No notes provided',

    // View page sections
    'exchange_request_details' => 'Exchange Request Details',
    'project_charter_details' => 'Project Charter Details',
    'project_charter_remaining_cost' => 'Charter Remaining Cost',
    'approval_history' => 'Approval History',
    'related_deliverable' => 'Related Deliverable',
    'no_transaction_file' => 'No transaction file uploaded yet',
    'no_transaction_files' => 'No transaction files uploaded yet',
    'no_additional_files' => 'No additional files uploaded yet',
    'completion_report_status' => 'Completion Report Status',

    // Approval form
    'transaction_file_upload' => 'Transaction File Upload',
    'transaction_file_upload_description' => 'Upload the transaction file for final approval',
    'approval_notes_description' => 'Add optional notes for this approval step',
    'status_updated_to' => 'Status updated to :status',
    'exchange_request_approved' => 'Exchange Request Approved',
    'exchange_request_rejected' => 'Exchange Request Rejected',

    // Additional status messages
    'pending' => 'Pending',
    'by_user' => 'by :name',
    'status_changed_from_to' => 'Status changed from :old_status to :new_status',
    'no_approval_history' => 'No approval history available yet',

    // Order and Association information
    'related_order_association' => 'Related Order & Association',
    'association_details' => 'Association Details',
    'association_name' => 'Association Name',
    'association_documents' => 'Association Documents',
    'authorization_letter' => 'Authorization Letter',
    'iban_certificate' => 'IBAN Certificate',
    'agreement_file' => 'Agreement File',
    'completion_report_file' => 'Completion Report File',
    'no_authorization_letter' => 'No authorization letter available',
    'no_iban_certificate' => 'No IBAN certificate available',
    'no_agreement_file' => 'No agreement file available',
    'no_completion_report_file' => 'No completion report file available',
    'view_order' => 'View Order',
    'view_association' => 'View Association',
    'download' => 'Download',

    // Export notifications
    'export_completed' => 'Your exchange request export has completed and :count :rows exported.',
    'export_failed_rows' => ' :count :rows failed to export.',
    'row' => 'row',
    'rows' => 'rows',

    // PDF Export
    'export_pdfs' => 'Export PDFs',
    'no_pdfs_found' => 'No PDFs Found',
    'no_pdfs_to_export' => 'There are no PDF files on this page to export.',
    'export_failed' => 'Export Failed',
    'export_error_message' => 'An error occurred while exporting the PDF files. Please try again.',

    // Files
    'file' => 'File',
    'no_files' => 'No files',
    'create' => 'Create',
];
