<?php

return [
    // Model names
    'donor_financial_portfolio' => 'Donor Financial Portfolio',
    'donor_financial_portfolios' => 'Donor Financial Portfolios',

    // Navigation
    'finance_management' => 'Finance Management',

    // Fields
    'name' => 'Portfolio Name',
    'balance' => 'Total Portfolio Value',
    'operating_percentage' => 'Operating Percentage',
    'total_operating_value' => 'Total Operating Value',
    'total_allocated' => 'Total Allocated',
    'remaining_balance' => 'Remaining Balance',
    'allocated_amount' => 'Allocated Amount',
    'orders_count' => 'Orders Count',
    'created_at' => 'Created',
    'updated_at' => 'Updated',

    // Form sections and descriptions
    'portfolio_information' => 'Portfolio Information',
    'portfolio_information_description' => 'Basic information about the donor financial portfolio',
    'allocation_information' => 'Allocation Information',
    'allocation_information_description' => 'Details about fund allocations to orders',

    // Form placeholders and helpers
    'name_placeholder' => 'Enter portfolio name',
    'balance_helper' => 'The total portfolio value available in this portfolio',
    'operating_percentage_placeholder' => 'Enter operating percentage',
    'operating_percentage_helper' => 'Operating percentage for the portfolio (0 to 100)',
    'allocated_amount_helper' => 'Amount to allocate from this portfolio to the order',
    'tag' => 'Tag',
    'tags' => 'Tags',
    'new_tag' => 'Add New Tag',

    // Filters
    'has_balance' => 'Has Remaining Balance',
    'low_balance' => 'Low Balance',
    'fully_allocated' => 'Fully Allocated',
    'over_allocated' => 'Over Allocated',

    // Actions
    'allocate_funds' => 'Allocate Funds',
    'deallocate_funds' => 'Deallocate Funds',
    'view_allocations' => 'View Allocations',
    'add_allocation' => 'Add',
    'remove_allocation' => 'Remove',

    // Status messages
    'allocation_successful' => 'Funds allocated successfully',
    'deallocation_successful' => 'Funds deallocated successfully',
    'insufficient_balance' => 'Insufficient balance in portfolio',
    'allocation_exceeds_order_price' => 'Total allocation exceeds order approved price',
    'portfolio_created' => 'Portfolio created successfully',
    'portfolio_updated' => 'Portfolio updated successfully',
    'portfolio_deleted' => 'Portfolio deleted successfully',

    // Validation messages
    'name_required' => 'Portfolio name is required',
    'balance_required' => 'Total portfolio value is required',
    'balance_positive' => 'Balance must be a positive number',
    'operating_percentage_required' => 'Operating percentage is required',
    'operating_percentage_numeric' => 'Operating percentage must be a number',
    'operating_percentage_between' => 'Operating percentage must be between 0 and 100',
    'allocated_amount_required' => 'Allocated amount is required',
    'allocated_amount_positive' => 'Allocated amount must be positive',

    // Table column descriptions
    'remaining_balance_description' => 'Calculated as: Initial Balance - Total Allocated',
    'total_allocated_description' => 'Sum of all allocations made from this portfolio',

    // Tooltips
    'balance_tooltip' => 'The original amount available in this portfolio',
    'remaining_balance_tooltip' => 'Amount still available for allocation',
    'allocation_tooltip' => 'Funds allocated to orders from this portfolio',

    // Workflow and allocation management
    'allocate_to_order' => 'Allocate to Order',
    'allocation_workflow' => 'Allocation Workflow',
    'order_allocation' => 'Order Allocation',
    'portfolio_allocation' => 'Portfolio Allocation',
    'allocation_history' => 'Allocation History',
    'allocation_date' => 'Allocation Date',
    'deallocation_date' => 'Deallocation Date',

    // Order status requirements
    'allocation_not_allowed' => 'Allocation not allowed at current order status',
    'allocation_allowed_after_approval' => 'Allocation only allowed after technical financial approval',
    'order_must_have_approved_price' => 'Order must have an approved price before allocation',

    // Partial funding
    'partial_funding_allowed' => 'Partial funding from multiple portfolios is allowed',
    'total_funding_warning' => 'Total funding cannot exceed order approved price',
    'remaining_funding_needed' => 'Remaining funding needed',
    'fully_funded' => 'Fully Funded',
    'partially_funded' => 'Partially Funded',
    'overfunded' => 'Overfunded',

    // Permissions and roles
    'allocation_permission_required' => 'You do not have permission to allocate funds',
    'finance_manager_role_required' => 'Finance Manager role required for allocation',

    // Portfolio allocation workflow - Additional keys
    'allocation_workflow_description' => 'Allocate funds from donor portfolios to this order',
    'allocation_percentage' => 'Allocation Percentage',
    'allocation_amount_preview' => 'Allocation Amount Preview',
    'portfolio_remaining_balance' => 'Portfolio Remaining Balance',
    'current_allocations' => 'Current Allocations',
    'no_allocations_yet' => 'No allocations added yet',
    'select_portfolio_and_percentage' => 'Please select a portfolio and enter percentage',
    'allocation_exceeds_100_percent' => 'Total allocation cannot exceed 100% of approved price',
    'portfolio_already_allocated' => 'This portfolio is already allocated to this order',

    // Relation manager specific keys
    'assign_to_portfolio' => 'Assign to Portfolio',
    'allocation' => 'Allocation',
    'allocations' => 'Allocations',
    'select_portfolio_helper' => 'Select a portfolio with available balance',
    'allocation_percentage_helper' => 'Enter the percentage of the order amount to allocate',
    'allocation_notes' => 'Allocation Notes',
    'allocation_notes_helper' => 'Optional notes about this allocation',
    'donor_name' => 'Donor Name',
    'allocated_at' => 'Allocated At',
    'filter_by_portfolio' => 'Filter by Portfolio',
    'allocation_success' => 'Funds allocated successfully',
    'no_allocations' => 'No Allocations',
    'no_allocations_description' => 'No funds have been allocated to this order yet.',
    'invalid_order_status_for_allocation' => 'Order must be in classification status or later to allow allocations',
    'total_allocation_exceeds_approved_price' => 'Total allocation (:total) exceeds approved price (:approved)',
    'portfolio_not_found' => 'Selected portfolio not found',
    'insufficient_portfolio_balance' => 'Insufficient portfolio balance. Required: :required, Available: :available',
    'allocation_exceeds_remaining' => 'Allocation percentage cannot exceed :max% (remaining available)',

    // Order rejection and deallocation
    'order_rejected_funds_deallocated' => 'Order rejected - all allocated funds have been returned to portfolios',
    'funds_returned_to_portfolio' => 'Funds returned to portfolio due to order rejection',

    // View page specific
    'related_orders' => 'Related Orders',
    'related_orders_description' => 'List of orders funded by this portfolio',
    'no_orders' => 'No orders have been funded by this portfolio yet.',
    'no_tags' => 'No tags assigned',
];
