<?php

return [
    // Model labels
    'admins_task' => 'Admin Task',
    'admins_tasks' => 'Admin Tasks',
    'task_management' => 'Task Management',

    // Fields
    'name' => 'Task Name',
    'description' => 'Description',
    'start_date' => 'Start Date',
    'end_date' => 'End Date',
    'status' => 'Status',
    'created_by' => 'Created By',
    'assigned_users' => 'Assigned Users',
    'created_at' => 'Created At',
    'updated_at' => 'Updated At',

    // Statuses
    'status_pending' => 'Pending',
    'status_in_progress' => 'In Progress',
    'status_completed' => 'Completed',
    'status_cancelled' => 'Cancelled',
    'status_on_hold' => 'On Hold',

    // Placeholders
    'name_placeholder' => 'Enter task name',
    'description_placeholder' => 'Enter task description',

    // Helper texts
    'name_helper' => 'Enter a clear and descriptive name for the task',
    'description_helper' => 'Provide detailed information about what needs to be done',
    'start_date_helper' => 'When should this task begin?',
    'end_date_helper' => 'When should this task be completed?',
    'assigned_users_helper' => 'Select users who will work on this task',

    // Actions
    'create_task' => 'Create Task',
    'edit_task' => 'Edit Task',
    'view_task' => 'View Task',
    'delete_task' => 'Delete Task',
    'assign_users' => 'Assign Users',
    'mark_in_progress' => 'Mark as In Progress',
    'mark_completed' => 'Mark as Completed',

    // Sections
    'basic_information' => 'Basic Information',
    'dates_information' => 'Dates Information',
    'assignment_information' => 'Assignment Information',

    // Filters
    'created_by_me' => 'Created by Me',

    // Messages
    'task_created' => 'Task created successfully',
    'task_updated' => 'Task updated successfully',
    'task_deleted' => 'Task deleted successfully',
    'no_tasks' => 'No tasks found',
    'overdue_task' => 'This task is overdue',

    // Stats
    'total_tasks' => 'Total Tasks',
    'pending_tasks' => 'Pending Tasks',
    'in_progress_tasks' => 'In Progress Tasks',
    'completed_tasks' => 'Completed Tasks',
    'overdue_tasks' => 'Overdue Tasks',
    'my_assigned_tasks' => 'My Assigned Tasks',

    // Progress
    'progress' => 'Progress',
    'progress_percentage' => 'Progress Percentage',

    // Attachments
    'attachments' => 'Attachments',
    'task_attachments' => 'Task Attachments',
    'task_attachments_helper' => 'You can upload multiple files for this task (PDF, Word, Excel, PowerPoint, Images)',
    'no_attachments' => 'No attachments',
    'attachments_count' => 'Attachments Count',

    // Checklist
    'checklist' => 'Checklist',
    'checklist_items' => 'Checklist Items',
    'checklist_item_title' => 'Item Title',
    'checklist_item_description' => 'Item Description',
    'checklist_item_attachments' => 'Item Attachments',
    'checklist_item_attachments_helper' => 'Upload files related to this checklist item (PDF, Word, Excel, PowerPoint, Images)',
    'add_checklist_item' => 'Add Checklist Item',
    'completed' => 'Completed',
    'checklist_completion' => 'Checklist Completion',
    'checklist_progress' => 'Checklist Progress',
    'completed_items' => 'Completed Items',
    'total_items' => 'Total Items',
    'no_checklist_items' => 'No checklist items',
    'checklist_completed' => 'All checklist items completed',
    'checklist_incomplete' => 'Some checklist items are incomplete',

    // Validation messages
    'name_required' => 'Task name is required',
    'start_date_before_end_date' => 'Start date must be before end date',
    'checklist_item_title_required' => 'Checklist item title is required',
];
