<?php

return [
    // Model names
    'donor_financial_portfolio' => 'المحفظة المالية',
    'donor_financial_portfolios' => 'المحافظ المالية',

    // Navigation
    'finance_management' => 'إدارة التمويل',

    // Fields
    'name' => 'اسم المحفظة',
    'balance' => 'إجمالي قيمة المحفظة',
    'operating_percentage' => 'نسبة التشغيل',
    'total_operating_value' => 'إجمالي قيمة التشغيل',
    'total_allocated' => 'المخصص من المحفظة',
    'remaining_balance' => 'الرصيد المتبقي',
    'allocated_amount' => 'المبلغ المخصص',
    'orders_count' => 'عدد الطلبات',
    'created_at' => 'تاريخ الإنشاء',
    'updated_at' => 'تاريخ التحديث',

    // Form sections and descriptions
    'portfolio_information' => 'معلومات المحفظة',
    'portfolio_information_description' => 'المعلومات الأساسية حول محفظة الممول المالية',
    'allocation_information' => 'معلومات التخصيص',
    'allocation_information_description' => 'تفاصيل حول تخصيص الأموال للطلبات',

    // Form placeholders and helpers
    'name_placeholder' => 'أدخل اسم المحفظة',
    'balance_helper' => 'إجمالي قيمة المحفظة المتاحة في هذه المحفظة',
    'operating_percentage_placeholder' => 'أدخل نسبة التشغيل',
    'operating_percentage_helper' => 'نسبة التشغيل للمحفظة (من 0 إلى 100)',
    'allocated_amount_helper' => 'المبلغ المراد تخصيصه من هذه المحفظة للطلب',
    'tag' => 'التصنيف',
    'tags' => 'التصنيفات',
    'new_tag' => 'إضافة تصنيف جديد',

    // Filters
    'has_balance' => 'لديها رصيد متبقي',
    'low_balance' => 'رصيد منخفض',
    'fully_allocated' => 'مخصصة بالكامل',
    'over_allocated' => 'مخصصة بشكل مفرط',

    // Actions
    'allocate_funds' => 'تخصيص الأموال',
    'deallocate_funds' => 'إلغاء تخصيص الأموال',
    'view_allocations' => 'عرض التخصيصات',
    'add_allocation' => 'إضافة',
    'remove_allocation' => 'إزالة',

    // Status messages
    'allocation_successful' => 'تم تخصيص الأموال بنجاح',
    'deallocation_successful' => 'تم إلغاء تخصيص الأموال بنجاح',
    'insufficient_balance' => 'رصيد غير كافي في المحفظة',
    'allocation_exceeds_order_price' => 'إجمالي التخصيص يتجاوز سعر الطلب المعتمد',
    'portfolio_created' => 'تم إنشاء المحفظة بنجاح',
    'portfolio_updated' => 'تم تحديث المحفظة بنجاح',
    'portfolio_deleted' => 'تم حذف المحفظة بنجاح',

    // Validation messages
    'name_required' => 'اسم المحفظة مطلوب',
    'balance_required' => 'إجمالي قيمة المحفظة مطلوب',
    'balance_positive' => 'يجب أن يكون الرصيد رقماً موجباً',
    'operating_percentage_required' => 'نسبة التشغيل مطلوبة',
    'operating_percentage_numeric' => 'نسبة التشغيل يجب أن تكون رقماً',
    'operating_percentage_between' => 'نسبة التشغيل يجب أن تكون بين 0 و 100',
    'allocated_amount_required' => 'المبلغ المخصص مطلوب',
    'allocated_amount_positive' => 'يجب أن يكون المبلغ المخصص موجباً',

    // Table column descriptions
    'remaining_balance_description' => 'محسوب كـ: إجمالي قيمة المحفظة - المخصص من المحفظة',
    'total_allocated_description' => 'مجموع جميع التخصيصات المقدمة من هذه المحفظة',

    // Tooltips
    'balance_tooltip' => 'إجمالي القيمة المتاحة في هذه المحفظة',
    'remaining_balance_tooltip' => 'المبلغ الذي لا يزال متاحاً للتخصيص',
    'allocation_tooltip' => 'الأموال المخصصة للطلبات من هذه المحفظة',

    // Workflow and allocation management
    'allocate_to_order' => 'تخصيص للطلب',
    'allocation_workflow' => 'سير عمل التخصيص',
    'order_allocation' => 'تخصيص الطلب',
    'portfolio_allocation' => 'تخصيص المحفظة',
    'allocation_history' => 'تاريخ التخصيصات',
    'allocation_date' => 'تاريخ التخصيص',
    'deallocation_date' => 'تاريخ إلغاء التخصيص',

    // Order status requirements
    'allocation_not_allowed' => 'التخصيص غير مسموح في حالة الطلب الحالية',
    'allocation_allowed_after_approval' => 'التخصيص مسموح فقط بعد الموافقة التقنية والمالية',
    'order_must_have_approved_price' => 'يجب أن يكون للطلب سعر معتمد قبل التخصيص',

    // Partial funding
    'partial_funding_allowed' => 'التمويل الجزئي من محافظ متعددة مسموح',
    'total_funding_warning' => 'إجمالي التمويل لا يمكن أن يتجاوز سعر الطلب المعتمد',
    'remaining_funding_needed' => 'التمويل المتبقي المطلوب',
    'fully_funded' => 'ممول بالكامل',
    'partially_funded' => 'ممول جزئياً',
    'overfunded' => 'ممول بشكل مفرط',

    // Permissions and roles
    'allocation_permission_required' => 'ليس لديك صلاحية لتخصيص الأموال',
    'finance_manager_role_required' => 'دور مدير التمويل مطلوب للتخصيص',

    // Portfolio allocation workflow - Additional keys
    'allocation_workflow_description' => 'تخصيص الأموال من محافظ المانحين لهذا الطلب',
    'allocation_percentage' => 'نسبة التخصيص',
    'allocation_amount_preview' => 'معاينة مبلغ التخصيص',
    'portfolio_remaining_balance' => 'الرصيد المتبقي للمحفظة',
    'current_allocations' => 'التخصيصات الحالية',
    'no_allocations_yet' => 'لم يتم إضافة تخصيصات بعد',
    'select_portfolio_and_percentage' => 'يرجى اختيار محفظة وإدخال النسبة المئوية',
    'allocation_exceeds_100_percent' => 'إجمالي التخصيص لا يمكن أن يتجاوز 100% من السعر المعتمد',
    'portfolio_already_allocated' => 'تم تخصيص هذه المحفظة بالفعل لهذا الطلب',

    // Relation manager specific keys
    'assign_to_portfolio' => 'إسناد للمحفظة',
    'allocation' => 'تخصيص',
    'allocations' => 'التخصيصات',
    'select_portfolio_helper' => 'اختر محفظة بها رصيد متاح',
    'allocation_percentage_helper' => 'أدخل نسبة مبلغ الطلب المراد تخصيصه',
    'allocation_notes' => 'ملاحظات التخصيص',
    'allocation_notes_helper' => 'ملاحظات اختيارية حول هذا التخصيص',
    'donor_name' => 'اسم المانح',
    'allocated_at' => 'مخصص في',
    'filter_by_portfolio' => 'تصفية حسب المحفظة',
    'allocation_success' => 'تم تخصيص الأموال بنجاح',
    'no_allocations' => 'لا توجد تخصيصات',
    'no_allocations_description' => 'لم يتم تخصيص أي أموال لهذا الطلب بعد.',
    'invalid_order_status_for_allocation' => 'يجب أن يكون الطلب في حالة التصنيف أو أحدث للسماح بالتخصيصات',
    'total_allocation_exceeds_approved_price' => 'إجمالي التخصيص (:total) يتجاوز السعر المعتمد (:approved)',
    'portfolio_not_found' => 'المحفظة المحددة غير موجودة',
    'insufficient_portfolio_balance' => 'رصيد المحفظة غير كافي. مطلوب: :required، متاح: :available',
    'allocation_exceeds_remaining' => 'نسبة التخصيص لا يمكن أن تتجاوز :max% (المتاح المتبقي)',

    // Order rejection and deallocation
    'order_rejected_funds_deallocated' => 'تم رفض الطلب - تم إرجاع جميع الأموال المخصصة إلى المحافظ',
    'funds_returned_to_portfolio' => 'تم إرجاع الأموال إلى المحفظة بسبب رفض الطلب',

    // View page specific
    'related_orders' => 'الطلبات المرتبطة',
    'related_orders_description' => 'قائمة الطلبات الممولة من هذه المحفظة',
    'no_orders' => 'لم يتم تمويل أي طلبات من هذه المحفظة بعد.',
    'no_tags' => 'لا توجد تصنيفات مسندة',
];
