# Quick Setup Guide for Auto Map Location Feature

## Prerequisites
Before testing this feature, you need to run the migrations and seed the coordinate data.

## Setup Steps

1. **Run Database Migrations**
   ```bash
   php artisan migrate
   ```

2. **Seed Coordinate Data** 
   ```bash
   php artisan db:seed --class=CoordinatesSeeder
   ```

3. **Verify Installation** (Optional)
   ```bash
   php artisan tinker < /tmp/verify_map_location_feature.php
   ```

## How to Test the Feature

### 1. Test Order Creation Form

1. Navigate to the Orders section in the admin panel
2. Click "Create Order" 
3. In the Location Information section:
   - Select a state from the State dropdown
   - Select a city from the City dropdown
   - **Expected Result**: The map should automatically move to show the selected city location

### 2. Test Association Order Creation

1. Log in as an association user
2. Navigate to Association Orders
3. Click "Create Order"
4. In the Location Information step:
   - Select a state
   - Select a city  
   - **Expected Result**: The map should automatically move to the selected city

### 3. Test Association Location Panel

1. Go to Association profile/settings
2. Navigate to the Geographic Scope or Location form
3. Select states and cities
   - **Expected Result**: The map should update to show the center point of selected cities

## Expected Behavior

- **Single City Selection**: Map centers on the selected city's coordinates
- **Multiple Cities Selection**: Map centers on the calculated center point of all selected cities  
- **Fallback Behavior**: If city coordinates aren't available, uses state coordinates
- **Default Fallback**: If no coordinates are available, defaults to Riyadh coordinates (24.7136, 46.6753)

## Troubleshooting

If the map doesn't update automatically:

1. **Check Console Errors**: Open browser developer tools and check for JavaScript errors
2. **Verify Data**: Ensure the CoordinatesSeeder was run successfully
3. **Check Database**: Verify that states and cities have lat/lng values:
   ```sql
   SELECT name, lat, lng FROM states WHERE lat IS NOT NULL LIMIT 5;
   SELECT name, lat, lng FROM cities WHERE lat IS NOT NULL LIMIT 5;
   ```

## Technical Notes

- The feature uses the `LocationCoordinatesService` to retrieve coordinates
- Map updates are triggered by Filament's `afterStateUpdated` callbacks
- Coordinates are stored as decimal fields with precision (10,8) for lat and (11,8) for lng
- The system includes comprehensive fallback logic for missing coordinate data