# Residential Gatherings - Automatic Center Creation

## Overview

The `residential:import` command has been enhanced to automatically handle missing centers during the import process. This ensures that residential gatherings can be imported even when their associated centers don't exist in the database.

## How It Works

### Center Lookup Strategy

When importing a residential gathering, the command follows this three-step strategy to find or create the appropriate center:

1. **Primary Lookup**: Search for a center with the exact name from the CSV
   - If found: Use this center
   - If multiple matches: Skip (needs manual resolution)
   - If not found: Continue to step 2

2. **Fallback Lookup**: Search for a center with name = city name
   - This handles cases where the center name in the CSV is missing or generic
   - If found: Use this center
   - If multiple matches: Skip (needs manual resolution)
   - If not found: Continue to step 3

3. **Auto-Creation**: Create a new center
   - The center name is normalized (replaces '-' with 'غير ذلك')
   - The center is created in the appropriate city
   - If the city doesn't exist: Skip (cannot create center)

### Center Name Normalization

- Centers named '-' in the CSV are automatically renamed to 'غير ذلك' (Other)
- This ensures consistency and meaningful names in the database

## Command Usage

### Import with Auto-Creation

```bash
# Normal import (with center creation)
php artisan residential:import

# Dry-run mode (preview without creating)
php artisan residential:import --dry-run

# Truncate before import
php artisan residential:import --truncate
```

### Import Statistics

The command now tracks:
- ✓ **Created**: Number of residential gatherings created
- ⊕ **Centers Created**: Number of centers automatically created
- ⊗ **Skipped (duplicate)**: Residential gatherings that already exist
- ⚠ **Skipped (center not found)**: Cases where the city doesn't exist
- ⚠ **Skipped (multiple centers)**: Cases with ambiguous center matches
- ✗ **Errors**: Import errors

### Example Output

```
═══════════════════════════════════════════════════════
          Import Summary
═══════════════════════════════════════════════════════
DRY RUN - No actual changes were made
✓ Created:                        15420
⊕ Centers Created:                85
⊗ Skipped (duplicate):            2350
⚠ Skipped (center not found):     1156
⚠ Skipped (multiple centers):     300
✗ Errors:                          0

Total processed: 19311
═══════════════════════════════════════════════════════

✓ 85 new centers were created automatically.
⚠ Some centers had multiple matches. Run location:merge-duplicate-centers first.
⚠ 1156 residential gatherings could not be matched (city not found).
```

## Dry-Run Mode

In dry-run mode:
- No centers are created
- No residential gatherings are created
- Statistics show what would happen
- Mock center objects are created for validation only

This allows you to preview the import results before making any database changes.

## Benefits

1. **Automatic Data Completion**: Missing centers are created automatically
2. **Safe Imports**: Dry-run mode lets you preview changes first
3. **Data Quality**: Center names are normalized for consistency
4. **Transparency**: Detailed statistics show what happened during import

## Technical Details

### Files Modified

- `app/Console/Commands/ImportResidentialGatherings.php`
  - Enhanced `findCenter()` method with three-step lookup strategy
  - Added center creation logic with dry-run support
  - Added `centers_created` statistic tracking
  - Updated statistics display

### Database Changes

The command may create new records in the `centers` table with:
- `name`: Normalized center name from CSV (or 'غير ذلك' for '-')
- `city_id`: Foreign key to the city from the CSV

## Best Practices

1. **Always use dry-run first**: `php artisan residential:import --dry-run`
2. **Review statistics**: Check how many centers will be created
3. **Handle duplicates**: Run `location:merge-duplicate-centers` if needed
4. **Verify cities exist**: Ensure all cities from CSV exist in database first
5. **Backup before import**: Especially when using `--truncate`

## Troubleshooting

### "Skipped (center not found)" Warnings

These occur when the city from the CSV doesn't exist in the database. Solutions:
- Import cities first using appropriate commands
- Check city names for spelling differences
- Review state/city hierarchy in the CSV

### Multiple Centers Match

This happens when duplicate centers exist with the same name in a city. Solutions:
- Run `php artisan location:merge-duplicate-centers` first
- Manually merge duplicate centers
- Use dry-run to identify problematic centers

### Centers Named 'غير ذلك'

These are intentionally created from CSV rows with center name = '-':
- This is expected behavior
- Represents "Other" or unspecified centers
- Can be renamed manually after import if needed
