# Location Duplicate Management - Quick Reference

## Commands Summary

### 1. Check for Duplicates
```bash
php artisan location:check-duplicates [--show-details]
```
Safe to run in production. No changes made.

### 2. Merge Duplicate Centers
```bash
# Preview changes
php artisan location:merge-duplicate-centers --dry-run --auto

# Apply changes automatically
php artisan location:merge-duplicate-centers --auto
```

### 3. Merge All Locations
```bash
# Preview all changes
php artisan location:merge-all-duplicates --dry-run --auto

# Apply all changes automatically
php artisan location:merge-all-duplicates --auto

# Merge only specific table
php artisan location:merge-all-duplicates --auto --centers
```

## Production Workflow

```bash
# Step 1: Check for duplicates
php artisan location:check-duplicates --show-details

# Step 2: Preview merge (if duplicates found)
php artisan location:merge-all-duplicates --dry-run --auto

# Step 3: Backup database
# pg_dump or your backup command

# Step 4: Merge duplicates
php artisan location:merge-all-duplicates --auto

# Step 5: Verify
php artisan location:check-duplicates
```

## What Gets Updated

### Centers (center_id)
- `center_order` pivot table
- `association_center` pivot table  
- `well_licenses.center_id`
- `station_licenses.center_id`
- `residential_gatherings.center_id`

### Cities (city_id)
- `centers.city_id`
- `orders.city_id`
- `association_city` pivot table
- `well_licenses.city_id`
- `station_licenses.city_id`

### States (state_id)
- `cities.state_id`
- `orders.state_id`
- `association_state` pivot table
- `well_licenses.state_id`
- `station_licenses.state_id`

## Safety Features
✓ Database transactions (auto-rollback on error)
✓ Dry-run mode available
✓ Smart pivot table handling
✓ All data preserved (consolidated, not lost)

## After Merging
Add unique constraints via migration:
```php
// States
$table->unique('name');

// Cities  
$table->unique(['name', 'state_id']);

// Centers
$table->unique(['name', 'city_id']);
```

See `MERGE_DUPLICATE_LOCATIONS.md` for detailed documentation.
