# Hosting Server Type

## 1. Overview
Sekaya is best hosted on a containerized, horizontally scalable infrastructure that prioritizes security, performance, and operational resilience. The recommended baseline environment is DigitalOcean using Droplets with Laravel Forge for orchestrated container deployment. 

## 2. Recommended Architecture Stack
| Layer | Technology | Rationale |
|-------|-----------|-----------|
| Application Runtime | Docker (PHP-FPM + Nginx) | Portability, isolation, consistent builds |
| Database | DigitalOcean Databases (PostgreSQL) | Managed backups, replication, encryption |
| Cache / Queue | Redis | High-performance ephemeral data store |
| Object Storage | DigitalOcean Object Storage | Durable, scalable, lifecycle management |
| Monitoring | Sentry | System metrics & application error insights |

## 3. Server OS & Runtime
- **Base Image**: Official PHP 8.2/8.4 FPM image + Nginx Alpine or Debian slim.
- **OS Hardening**: Minimal packages, non-root containers, read-only filesystem for runtime where feasible.
- **PHP Configuration**: Opcache enabled, memory limits tuned (e.g., 512M), production error handling (no display errors).

## 4. Network & Connectivity
| Aspect | Design |
|--------|--------|
| VPC | Isolated private subnets for application & database |
| Load Balancer | Application Load Balancer (ALB) with HTTPS termination |
| Security Groups | Principle of least privilege: ingress restricted to LB; egress limited |
| Public Access | Only CDN + ALB exposed; DB & Redis private |
| TLS | ACM-issued certificates; enforced TLS 1.2+ |

## 5. Scaling & Capacity
| Dimension | Strategy |
|----------|----------|
| Horizontal App Scaling | Auto-scale on CPU & request latency thresholds |
| Queue Workers | Separate task definition; scaled on pending job depth |
| Database | Start with single instance + automated backups; add read replica when read-heavy |
| Redis | Cluster mode optional as concurrency grows |
| Storage | S3 scales automatically; lifecycle rules optimize cost |

Initial sizing (illustrative baseline):
- 2 vCPU / 4 GB RAM per application task
- 1-2 queue worker tasks (same size) adjustable based on job throughput
- RDS db.m6g.large or equivalent (2 vCPU, 8 GB RAM) baseline

## 6. Deployment Strategy
- **Build Phase**: Multi-stage Docker build (composer install, npm build → production image).
- **Rollback**: Previous image retained; revert via deployment trigger.

## 7. Security Controls
| Control | Implementation |
|---------|---------------|
| IAM Roles | Task roles granting scoped S3 |
| Network Isolation | Private subnets; no direct DB public exposure |
| Data in Transit | HTTPS enforced; internal TLS optional for service mesh |
| Vulnerability Scanning | dependency audit (Composer/npm) |

## 8. Backup & Disaster Recovery
| Asset | Method | Frequency |
|-------|-------|-----------|
| Database | Automated RDS snapshots | Daily + point-in-time restore |
| Media Files | S3 lifecycle + versioning | Continuous; periodic integrity audit |
| Source Code | Git repository | Continuous |

DR scenario: Restore from latest snapshot → rehydrate media via S3 → redeploy containers referencing same release.

## 9. Compliance & Governance
- **Logging**: Sentry structured logs retained (e.g., 90 days) then archived.
- **Access Auditing**: IAM actions tracked; application audit via Activity Log.
- **Encryption Policies**: All at rest assets encrypted (RDS, EBS, S3). TLS enforced.

## 10. Cross-References
Supporting documents:
- `SYSTEM_DESIGN.md` – Application layering mapped to infrastructure.
- `DATABASE_DESIGN.md` – Persistence model informing RDS configuration.
- `TECH_STACK.md` – Components deployed within this environment.
- `SERVER_KEY_FEATURES.md` – Feature inventory leveraging hosting capabilities.

## 14. Summary
The recommended hosting environment delivers secure, cost-efficient scalability while minimizing operational burden.
