<?php

namespace Database\Seeders;

use App\Models\SekayaValue;
use Illuminate\Database\Seeder;

class SekayaValueSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $impactReasons = [
            'تقليل التكاليف على الأهالي وجعل توفير المياه بمتناول الأيدي',
            'تحقيق الأثر الصحي بتوفير مياه صالحة للشرب',
            'تمكين الجمعية المحلية بالاستفادة من الاستثمار الاجتماعي',
            'سد حاجة الاسر من الاحتياج اليومي للمياه العذبة',
            'راحة الأسر من عناء الذهاب للبحث عن المياه كل يوم',
            'تحقيق هدف من الأهداف الإستراتيجية للجمعية',
            'تقليل التكلفة على الاسر',
            'تحسين جودة الحياة وتحقيق احد مستهدفات رؤية 2030.',
            'توفير عدة وظائف سواقين صهاريج مما يساهم في تخفيف البطالة',
            'معالجة شح المياه والحد من الاسر التي تعاني من عدم القدرة على توفير مياه',
            'تخفيض تكلفة نقل الماء للمستفيد',
            'كفاية الأسر المحتاجة بتوفير المياه لهم بشكل دوري',
            'توفير المياه الصالحة للشرب للأسر المستفيدة وتحقيق نسبة الكفاية لديهم',
            'تحسين الاستدامة البيئية حيث سيتم توفير مياه نقية صالحة للشرب',
            'تعزيز النمو الاقتصادي والاستدامة المالية',
            'زيادة التكاتف والتكافل والمساهمة المجتمعية',
        ];

        foreach ($impactReasons as $reason) {
            SekayaValue::firstOrCreate([
                'name' => $reason,
                'type' => SekayaValue::TYPE_ORDER_IMPACT_REASONS,
            ]);
        }

        // PERFORMANCE_CARD_PRODUCT
        $performanceCardProducts = [
            'محطات التنقية',
            'محطات تحلية',
            'الصهاريج',
            'الخزانات المنزلية',
            'الخزانات المركزية',
            'الشبكات المصغرة',
            'تصميم منتجات جديدة',
            'حصاد مياه الأمطار',
            'حفر الآبار',
            'صيانة وتشغيل الصهاريج',
            'صيانة وتشغيل محطات',
            'تراخيص الآبار',
            'تراخيص المحطات',
            'تراخيص الصهاريج',
            'نظام الرقابة والمتابعة',
            'برامج التدريب والتأهيل',
            'آلية تنازلات الأراضي',
            'مكتب إدارة المشاريع',
            'الريانات',
            'حافظات زمزم',
            'برنامج السقيا الخيري',
            'برنامج موارد البادية',
            'برنامج الآبار',
            'الحل التقني',
        ];

        foreach ($performanceCardProducts as $product) {
            SekayaValue::firstOrCreate([
                'name' => $product,
                'type' => SekayaValue::TYPE_PERFORMANCE_CARD_PRODUCT,
            ]);
        }
    }
}
