<?php

namespace Database\Seeders;

use App\Models\Association;
use App\Models\Order;
use App\Models\SekayaValue;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;

class OrderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $association = Association::first();
        $user = User::where('association_id', $association->id)->first();

        // Create orders of different types
        $orders = [
            [
                'type' => Order::TYPE_DOMESTIC_STORAGE_TANK,
                'created_by' => $user->id,
                'association_id' => $association->id,
            ],
            [
                'type' => Order::TYPE_DOMESTIC_STORAGE_TANK,
                'created_by' => $user->id,
                'association_id' => $association->id,
            ],
            [
                'type' => Order::TYPE_DOMESTIC_STORAGE_TANK,
                'created_by' => $user->id,
                'association_id' => $association->id,
            ],
        ];

        $sekayaValues = SekayaValue::where('type', SekayaValue::TYPE_ORDER_IMPACT_REASONS)->get();
        foreach ($orders as $orderData) {
            $order = Order::create($orderData);

            if ($sekayaValues->isNotEmpty()) {
                $order->developmentImpacts()->attach($sekayaValues->random(rand(2, 5))->pluck('id'));
            }

            // Add sample files based on order type
            // if ($order->type === Order::TYPE_STATION) {
            //     // Create fake files using temporary files
            //     $locationFile = UploadedFile::fake()->create('station-location.pdf', 1024);
            //     $licenseFile = UploadedFile::fake()->create('station-license.pdf', 1024);

            //     $order->addOrderFile($locationFile, 'Station Location');
            //     $order->addOrderFile($licenseFile, 'Station License');
            // } elseif ($order->type === Order::TYPE_TANKER) {
            //     $specsFile = UploadedFile::fake()->create('tanker-specs.pdf', 1024);
            //     $order->addOrderFile($specsFile, 'Tanker Specs');
            // }
            // Storage tank orders don't need files
        }
    }
}
