<?php

namespace Database\Seeders;

use App\Models\DonorFinancialPortfolio;
use Illuminate\Database\Seeder;

class MigrateDonorPortfolioAccessSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get all portfolios with their creators
        $portfolios = DonorFinancialPortfolio::withoutAccessScope()
            ->whereNotNull('created_by')
            ->with('creator')
            ->get();

        foreach ($portfolios as $portfolio) {
            if ($portfolio->creator) {
                // Attach the creator to the portfolio if not already attached
                $portfolio->users()->syncWithoutDetaching([$portfolio->creator->id]);
                $this->command->info("Linked portfolio '{$portfolio->name}' to its creator '{$portfolio->creator->name}'");
            }
        }

        $this->command->info('Portfolio access migration completed successfully.');
    }
}
