<?php

namespace Database\Seeders;

use App\Models\DonorFinancialPortfolio;
use Illuminate\Database\Seeder;

class DonorFinancialPortfolioSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $portfolios = [
            [
                'name' => 'Water Access Foundation Portfolio',
                'balance' => 1000000.00,
                'operating_percentage' => 7.5,
            ],
            [
                'name' => 'Rural Development Fund',
                'balance' => 750000.00,
                'operating_percentage' => 5.0,
            ],
            [
                'name' => 'Emergency Relief Portfolio',
                'balance' => 500000.00,
                'operating_percentage' => 10.0,
            ],
            [
                'name' => 'Community Infrastructure Fund',
                'balance' => 2000000.00,
                'operating_percentage' => 6.5,
            ],
        ];

        foreach ($portfolios as $portfolioData) {
            DonorFinancialPortfolio::create($portfolioData);
        }
    }
}
