<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Essential seeders that run in all environments
        $essentialSeeders = [
            LocationSeeder::class,
            WaterSourceSeeder::class,
            SekayaValueSeeder::class,
            RoleSeeder::class,
            UserSeeder::class,
            AdminsTaskStatusSeeder::class,
        ];

        // Additional seeders that only run in development/debug mode
        $developmentSeeders = [
            DonorFinancialPortfolioSeeder::class,
            AssociationSeeder::class,
            OrderSeeder::class,
            PerformanceCardSeeder::class,
        ];

        // Comprehensive seeding for full system testing
        $comprehensiveSeeders = [
            ComprehensiveSeeder::class,
            DevelopmentSeeder::class,
        ];

        $this->command->info('Running essential seeders (all environments)...');
        // Always run essential seeders
        $this->call($essentialSeeders);

        // Only run development seeders in non-production environments
        if (! app()->environment('production')) {
            $this->command->info('Running development seeders (non-production only)...');
            $this->call($developmentSeeders);

            // Ask if user wants comprehensive seeding
            if ($this->command->confirm('Do you want to run comprehensive seeding? This will create extensive test data.', false)) {
                $this->command->info('Running comprehensive seeders for full system testing...');
                $this->call($comprehensiveSeeders);
            }
        } else {
            $this->command->info('Skipping development seeders (production environment)');
        }
    }
}
