<?php

namespace Database\Seeders;

use App\Models\City;
use Illuminate\Database\Seeder;

class CoordinatesSeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        $this->command->info('Starting coordinates seeding...');

        City::with('state')->chunkById(500, function ($cities) {
            foreach ($cities as $city) {
                $city->update([
                    'state_name' => $city->state?->getTranslation('name', 'ar'),
                ]);
            }
        });

        $this->command->info('Coordinates seeding completed!');
    }
}
