<?php

namespace Database\Seeders;

use App\Models\Association;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class AssociationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create first association
        $association1 = Association::create([
            'name' => 'Green Valley Environmental Association',
            'license_number' => 'GVEA-2024-001',
            'license_expiration_date' => '2025-12-31',
            'representative_full_name' => 'John Smith',
            'representative_position' => 'President',
            'phone_number' => '+1234567890',
            'email' => 'info@greenvalley.com',
            'secondary_phone_number' => '+1234567891',

            // Address information
            'city' => 'Riyadh',
            'postal_code' => '12345',
            'neighborhood' => 'Al Olaya',
            'building_number' => '123',
            'street' => 'King Fahd Road',
            'branch_number' => '1',

            // Banking information
            'iban' => 'SA1234567890123456789012',
            'bank_name' => 'Saudi National Bank',
            'account_holder_name' => 'Green Valley Environmental Association',

        ]);

        // Create first association admin
        $admin1 = User::factory()->create([
            'name' => 'Green Valley Admin',
            'email' => 'admin@greenvalley.com',
            'password' => Hash::make('Pa$$w0rd!'),
            'association_id' => $association1->id,
        ]);
        // $admin1->assignRole('association admin');

        // Create second association
        $association2 = Association::create([
            'name' => 'Urban Forest Conservation Society',
            'license_number' => 'UFCS-2024-002',
            'license_expiration_date' => '2026-06-30',
            'representative_full_name' => 'Sarah Johnson',
            'representative_position' => 'Executive Director',
            'phone_number' => '+1234567892',
            'email' => 'contact@urbanforest.com',
            'secondary_phone_number' => '+1234567893',

            // Address information
            'city' => 'Jeddah',
            'postal_code' => '23456',
            'neighborhood' => 'Al Hamra',
            'building_number' => '456',
            'street' => 'Prince Mohammed bin Abdulaziz Road',
            'branch_number' => '2',

            // Banking information
            'iban' => 'SA9876543210987654321098',
            'bank_name' => 'Al Rajhi Bank',
            'account_holder_name' => 'Urban Forest Conservation Society',

        ]);

        // Create second association admin
        $admin2 = User::factory()->create([
            'name' => 'Urban Forest Admin',
            'email' => 'admin@urbanforest.com',
            'password' => Hash::make('Pa$$w0rd!'),
            'association_id' => $association2->id,
        ]);
        // $admin2->assignRole('association admin');
    }
}
