<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class AdminsTaskStatusSeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        $statuses = [
            [
                'key' => 'pending',
                'title' => __('admins_task.status_pending'),
                'icon' => 'heroicon-o-clock',
                'color' => 'gray',
                'order_column' => 1,
                'is_active' => true,
            ],
            [
                'key' => 'in_progress',
                'title' => __('admins_task.status_in_progress'),
                'icon' => 'heroicon-o-play',
                'color' => 'blue',
                'order_column' => 2,
                'is_active' => true,
            ],
            [
                'key' => 'on_hold',
                'title' => __('admins_task.status_on_hold'),
                'icon' => 'heroicon-o-pause',
                'color' => 'yellow',
                'order_column' => 3,
                'is_active' => true,
            ],
            [
                'key' => 'completed',
                'title' => __('admins_task.status_completed'),
                'icon' => 'heroicon-o-check-circle',
                'color' => 'success',
                'order_column' => 4,
                'is_active' => true,
            ],
            [
                'key' => 'cancelled',
                'title' => __('admins_task.status_cancelled'),
                'icon' => 'heroicon-o-x-circle',
                'color' => 'danger',
                'order_column' => 5,
                'is_active' => true,
            ],
        ];

        foreach ($statuses as $status) {
            \App\Models\AdminsTaskStatus::updateOrCreate(
                ['key' => $status['key']],
                $status
            );
        }
    }
}
