<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('station_licenses', function (Blueprint $table) {
            $table->date('delegation_start_date')->nullable()->after('ministry_license_end_date');
            $table->date('delegation_end_date')->nullable()->after('delegation_start_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('station_licenses', function (Blueprint $table) {
            $table->dropColumn(['delegation_start_date', 'delegation_end_date']);
        });
    }
};
