<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('station_licenses', function (Blueprint $table) {
            $table->integer('evaporation_ponds_count')->nullable()->after('evaporation_ponds_area')->comment('عدد الأحواض');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('station_licenses', function (Blueprint $table) {
            $table->dropColumn('evaporation_ponds_count');
        });
    }
};
